/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.stability;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class ConflictingWritesDontBreakSystemStressTest {
    private TransactionalInteger[] refs;
    private int structureCount = 100;
    private int writerThreadCount = 10;
    private int transactionCount = 100;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.setUpStructures();
        TestThread[] threads = this.createWriterThreads();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        this.assertValues(this.transactionCount * 10);
    }

    private void assertValues(int value) {
        for (TransactionalInteger ref : this.refs) {
            Assert.assertEquals((long)value, (long)ref.get());
        }
    }

    private void setUpStructures() {
        this.refs = new TransactionalInteger[this.structureCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = new TransactionalInteger(0);
        }
    }

    private WriterThread[] createWriterThreads() {
        WriterThread[] threads = new WriterThread[this.writerThreadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new WriterThread(k);
        }
        return threads;
    }

    private class WriterThread
    extends TestThread {
        private WriterThread(int id) {
            super("WriterThread-" + id);
        }

        public void doRun() {
            for (int k = 0; k < ConflictingWritesDontBreakSystemStressTest.this.transactionCount; ++k) {
                if (k % 10 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                this.doTransaction();
            }
        }

        @TransactionalMethod
        public void doTransaction() {
            for (int k = 0; k < ConflictingWritesDontBreakSystemStressTest.this.refs.length; ++k) {
                TransactionalInteger ref = ConflictingWritesDontBreakSystemStressTest.this.refs[k];
                TestUtils.sleepRandomMs((int)1);
                ref.inc();
            }
        }
    }
}

