/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;

public class AlphaStm_FamilyNameTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void explicitFamilyName() {
        String familyName = "customfamilyname";
        Transaction tx = this.stm.getTransactionFactoryBuilder().setFamilyName(familyName).build().start();
        Assert.assertEquals((Object)familyName, (Object)tx.getConfiguration().getFamilyName());
    }

    @Test
    public void defaultFamilyName() {
        Transaction tx = this.stm.getTransactionFactoryBuilder().build().start();
        String family1 = tx.getConfiguration().getFamilyName();
        Assert.assertTrue((boolean)family1.startsWith("TransactionFamily-"));
        long id = this.getId(family1);
        Assert.assertTrue((id > 0L ? 1 : 0) != 0);
    }

    @Test
    public void defaultFamilyNamesIncrease() {
        Transaction tx1 = this.stm.getTransactionFactoryBuilder().build().start();
        Transaction tx2 = this.stm.getTransactionFactoryBuilder().build().start();
        Assert.assertEquals((long)(this.getId(tx1.getConfiguration().getFamilyName()) + 1L), (long)this.getId(tx2.getConfiguration().getFamilyName()));
    }

    long getId(String familyName) {
        int indexOf = familyName.indexOf("-");
        return Long.parseLong(familyName.substring(indexOf + 1));
    }
}

