/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.transactions.update.AbstractUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;

public class AlphaStm_NonSpeculativeTransactionSettingsTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void testDefaultTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        Assert.assertTrue((boolean)(t instanceof AbstractUpdateAlphaTransaction));
        TestUtils.testIncomplete();
    }

    @Test
    public void testDefaultUpdateTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        Assert.assertTrue((boolean)(t instanceof MapUpdateAlphaTransaction));
        Assert.assertFalse((boolean)t.getConfiguration().isReadonly());
        Assert.assertFalse((boolean)t.getConfiguration().isReadTrackingEnabled());
        Assert.assertTrue((boolean)t.getConfiguration().isWriteSkewAllowed());
        Assert.assertEquals((long)1000L, (long)t.getConfiguration().getMaxRetries());
        Assert.assertFalse((boolean)t.getConfiguration().isInterruptible());
    }

    @Test
    public void test() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadTrackingEnabled(true).build().start();
        Assert.assertTrue((boolean)(t instanceof AbstractUpdateAlphaTransaction));
        Assert.assertFalse((boolean)t.getConfiguration().isReadonly());
        Assert.assertTrue((boolean)t.getConfiguration().isReadTrackingEnabled());
        Assert.assertTrue((boolean)t.getConfiguration().isWriteSkewAllowed());
        Assert.assertEquals((long)1000L, (long)t.getConfiguration().getMaxRetries());
        Assert.assertFalse((boolean)t.getConfiguration().isInterruptible());
    }

    @Test
    public void testNonTrackingUpdate() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).setReadTrackingEnabled(true).build().start();
        Assert.assertTrue((boolean)(t instanceof MapUpdateAlphaTransaction));
    }

    @Test(expected=IllegalStateException.class)
    public void whenUpdateTransactionWithWriteSkewDetectionAndNoAutomaticReadTracking_thenIllegalStateException() {
        this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).setReadTrackingEnabled(false).setWriteSkewAllowed(false).build();
    }

    @Test
    public void whenReadonlyTransactionWithWriteSkewDetectionAndNoAutomaticReadTracking_thenIgnore() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(true).setReadTrackingEnabled(false).setWriteSkewAllowed(true).build();
    }
}

