/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTestUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class EmptyConstructionTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @After
    public void after() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void problematicConstructionFollowedByReadonlyTransaction() {
        ProblematicObject ref = new ProblematicObject();
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setReadonly(true).build().start();
        tx.openForRead((AlphaTransactionalObject)ref);
    }

    @Test
    public void problematicConstructionFollowedByUpdateTransactionSucceeds() {
        ProblematicObject ref = new ProblematicObject();
        AlphaTransaction tx = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        AlphaTranlocal tranlocal = tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertNotNull((Object)tranlocal);
        Assert.assertSame((Object)ref, (Object)tranlocal.getTransactionalObject());
        Assert.assertNotNull((Object)tranlocal.getOrigin());
        Assert.assertTrue((boolean)tranlocal.isUncommitted());
    }

    @TransactionalObject
    static class ProblematicObject {
        Object value;

        ProblematicObject() {
        }

        ProblematicObject(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

