/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.transactions.readonly.MonoReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;

public class SpeculativeNonAutomaticReadTrackingTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenReadonlyAndAutomaticReadtrackingNeeded() {
        SpeculativeReadTrackingDisabled o = new SpeculativeReadTrackingDisabled();
        o.set(1);
        new DelayedSetThread(o).start();
        o.getZeroOrWait();
        Assert.assertEquals((String)("" + o.transactions), (long)3L, (long)o.transactions.size());
        TestUtils.assertInstanceOf(o.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(1), MonoReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(2), MonoReadonlyAlphaTransaction.class);
        SpeculativeReadTrackingDisabled o2 = new SpeculativeReadTrackingDisabled();
        o2.set(1);
        DelayedSetThread t = new DelayedSetThread(o2);
        t.start();
        o2.getZeroOrWait();
        Assert.assertEquals((long)2L, (long)o2.transactions.size());
        TestUtils.assertInstanceOf(o2.transactions.get(0), MonoReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o2.transactions.get(1), MonoReadonlyAlphaTransaction.class);
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenReadonlyAndNoAutomaticReadtrackingNeeded() {
        SpeculativeReadTrackingDisabled o = new SpeculativeReadTrackingDisabled();
        o.getZeroOrFail();
        Assert.assertEquals((long)1L, (long)o.transactions.size());
        TestUtils.assertInstanceOf(o.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
        SpeculativeReadTrackingDisabled o2 = new SpeculativeReadTrackingDisabled();
        o2.getZeroOrFail();
        Assert.assertEquals((long)1L, (long)o2.transactions.size());
        TestUtils.assertInstanceOf(o2.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
    }

    @Test
    public void whenUpdateAndAutomaticReadtrackingNeeded() {
        SpeculativeReadTrackingDisabled o = new SpeculativeReadTrackingDisabled();
        o.set(1);
        new DelayedSetThread(o).start();
        o.setOneIfZeroOrWait();
        Assert.assertEquals((long)4L, (long)o.transactions.size());
        TestUtils.assertInstanceOf(o.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(1), MonoReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(2), MonoReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(3), MonoUpdateAlphaTransaction.class);
        SpeculativeReadTrackingDisabled o2 = new SpeculativeReadTrackingDisabled();
        o2.set(1);
        DelayedSetThread t = new DelayedSetThread(o2);
        t.start();
        o2.setOneIfZeroOrWait();
        Assert.assertEquals((long)2L, (long)o2.transactions.size());
        TestUtils.assertInstanceOf(o2.transactions.get(0), MonoUpdateAlphaTransaction.class);
        TestUtils.assertInstanceOf(o2.transactions.get(1), MonoUpdateAlphaTransaction.class);
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenUpdateAndNoAutomaticReadTrackingNeeded() throws InterruptedException {
        SpeculativeReadTrackingDisabled o = new SpeculativeReadTrackingDisabled();
        o.setOneIfZeroOrFail();
        Assert.assertEquals((long)2L, (long)o.transactions.size());
        TestUtils.assertInstanceOf(o.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(1), MonoUpdateAlphaTransaction.class);
        SpeculativeReadTrackingDisabled o2 = new SpeculativeReadTrackingDisabled();
        DelayedSetThread t = new DelayedSetThread(o2);
        ((Thread)((Object)t)).start();
        o2.setOneIfZeroOrFail();
        Assert.assertEquals((long)1L, (long)o2.transactions.size());
        TestUtils.assertInstanceOf(o2.transactions.get(0), MonoUpdateAlphaTransaction.class);
        ((Thread)((Object)t)).join();
    }

    public class DelayedSetThread
    extends TestThread {
        private final SpeculativeReadTrackingDisabled o;

        public DelayedSetThread(SpeculativeReadTrackingDisabled o) {
            this.o = o;
        }

        public void doRun() throws Exception {
            TestUtils.sleepMs((long)500L);
            this.o.set(0);
        }
    }

    @TransactionalObject
    class SpeculativeReadTrackingDisabled {
        private int value;
        @NonTransactional
        private List<Transaction> transactions = new LinkedList<Transaction>();

        SpeculativeReadTrackingDisabled() {
        }

        public void set(int value) {
            this.value = value;
        }

        public void getZeroOrFail() {
            this.transactions.add(ThreadLocalTransaction.getThreadLocalTransaction());
            if (this.value != 0) {
                throw new RuntimeException();
            }
        }

        public void getZeroOrWait() {
            this.transactions.add(ThreadLocalTransaction.getThreadLocalTransaction());
            if (this.value != 0) {
                StmUtils.retry();
            }
        }

        public void setOneIfZeroOrFail() {
            this.transactions.add(ThreadLocalTransaction.getThreadLocalTransaction());
            if (this.value != 0) {
                throw new RuntimeException();
            }
            this.value = 1;
        }

        public void setOneIfZeroOrWait() {
            this.transactions.add(ThreadLocalTransaction.getThreadLocalTransaction());
            if (this.value != 0) {
                StmUtils.retry();
            } else {
                this.value = 1;
            }
        }
    }
}

