/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;

public class SpeculativeReadonlyTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenSpeculativeReadonlyAndRead_thenSpeculationSuccessful() {
        SpeculativeReadonly o = new SpeculativeReadonly();
        o.read();
        Assert.assertEquals((long)1L, (long)o.transactions.size());
        TestUtils.assertInstanceOf(o.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
        SpeculativeReadonly o2 = new SpeculativeReadonly();
        o2.read();
        Assert.assertEquals((long)1L, (long)o2.transactions.size());
        TestUtils.assertInstanceOf(o2.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
    }

    @Test
    public void whenSpeculativeReadonlyAndWrite_thenSpeculationSuccessfulAndUpgradedToWrite() {
        SpeculativeReadonly o = new SpeculativeReadonly();
        o.update();
        Assert.assertEquals((long)2L, (long)o.transactions.size());
        TestUtils.assertInstanceOf(o.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(1), MonoUpdateAlphaTransaction.class);
        SpeculativeReadonly o2 = new SpeculativeReadonly();
        o2.update();
        Assert.assertEquals((long)1L, (long)o2.transactions.size());
        TestUtils.assertInstanceOf(o2.transactions.get(0), MonoUpdateAlphaTransaction.class);
    }

    @TransactionalObject
    class SpeculativeReadonly {
        private int foo;
        @NonTransactional
        private List<Transaction> transactions = new LinkedList<Transaction>();

        SpeculativeReadonly() {
        }

        public void read() {
            this.transactions.add(ThreadLocalTransaction.getThreadLocalTransaction());
            System.out.println("Reading:" + this.foo);
        }

        public void update() {
            this.transactions.add(ThreadLocalTransaction.getThreadLocalTransaction());
            ++this.foo;
        }
    }
}

