/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;

public class InstrumentationTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void nonTransactionalObjectIsNotTransformed() {
        NonTransactionalObject o = new NonTransactionalObject();
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
    }

    @Test
    public void statelessObjectIsNotTransformed() {
        StatelessObject object = new StatelessObject();
        Assert.assertFalse((boolean)(object instanceof AlphaTransactionalObject));
    }

    @Test
    public void objectWithStaticFieldAndPrimitiveFieldIsTransformed() {
        ObjectWithStaticFieldAndPrimitiveField o = new ObjectWithStaticFieldAndPrimitiveField();
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
    }

    @Test
    public void objectWithOnlyStaticFieldIsNotTransformed() {
        ObjectWithStaticField o = new ObjectWithStaticField();
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
    }

    @Test
    public void objectWithOnlyASingleFinalFieldIsNotTransformed() {
        ObjectWithOnlySingleFinalField o = new ObjectWithOnlySingleFinalField();
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
        o.getClass();
        Assert.assertEquals((long)10L, (long)10L);
    }

    @Test
    public void objectWithMultipleFinalFieldIsNotTransformed() {
        ObjectWithMultipleFinalField o = new ObjectWithMultipleFinalField();
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
        o.getClass();
        Assert.assertEquals((long)10L, (long)10L);
        o.getClass();
        Assert.assertEquals((long)20L, (long)20L);
    }

    @Test
    public void objectWithFinalsAndNonFinalsIsTransformed() {
        ObjectWithFinalsAndNonFinals o = new ObjectWithFinalsAndNonFinals();
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
        o.getClass();
        Assert.assertEquals((long)10L, (long)10L);
        o.getClass();
        Assert.assertEquals((long)20L, (long)20L);
        Assert.assertEquals((long)30L, (long)o.getZ());
    }

    public void objectWithOnlyMutablePrimitiveIsTransformed() {
        ObjectWithMutablePrimitive o = new ObjectWithMutablePrimitive();
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
    }

    @TransactionalObject
    public static class ObjectWithMutablePrimitive {
        int value;
    }

    @TransactionalObject
    public static class ObjectWithFinalsAndNonFinals {
        final int x = 10;
        final int y = 20;
        int z = 30;

        public int getZ() {
            return this.z;
        }
    }

    @TransactionalObject
    public static class ObjectWithMultipleFinalField {
        final int x = 10;
        final int y = 20;
    }

    @TransactionalObject
    public static class ObjectWithOnlySingleFinalField {
        final int x = 10;
    }

    @TransactionalObject
    public static class ObjectWithStaticField {
        static int x;
    }

    @TransactionalObject
    public static class ObjectWithStaticFieldAndPrimitiveField {
        static int x;
        int y;
    }

    @TransactionalObject
    public static class StatelessObject {
    }

    static class NonTransactionalObject {
        NonTransactionalObject() {
        }
    }
}

