/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalConstructor;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalConstructor_accessModifierTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void noArgTxConstructor() {
        long version = this.stm.getVersion();
        NoArgTxConstructor o = new NoArgTxConstructor();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)20L, (long)o.value);
    }

    @Test
    public void singleArgTxConstructor() {
        long version = this.stm.getVersion();
        SingleArgTxConstructor o = new SingleArgTxConstructor(20);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)20L, (long)o.arg);
    }

    @Test
    public void multiArgTxConstructor() {
        long version = this.stm.getVersion();
        MultiArgTxConstructor o = new MultiArgTxConstructor(6, 7, 8, 9);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)6L, (long)o.arg1);
        Assert.assertEquals((long)7L, (long)o.arg2);
        Assert.assertEquals((long)8L, (long)o.arg3);
        Assert.assertEquals((long)9L, (long)o.arg4);
    }

    @Test
    public void constructorWithCheckedException() {
        long version = this.stm.getVersion();
        try {
            new ConstructorWithCheckedException(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void constructorWithCheckedExceptionThatIsNotThrown() throws Exception {
        long version = this.stm.getVersion();
        ConstructorWithCheckedException o = new ConstructorWithCheckedException(false);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void testPublicConstructor() {
        long version = this.stm.getVersion();
        PublicConstructor o = new PublicConstructor();
        Assert.assertEquals((long)10L, (long)o.value);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void testFinalField() {
        long version = this.stm.getVersion();
        FinalField o = new FinalField(1);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.value);
    }

    @Test
    public void testProtectedConstructor() {
        long version = this.stm.getVersion();
        ProtectedConstructor o = new ProtectedConstructor();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)o.value);
    }

    @Test
    public void testPackageFriendlyConstructor() {
        long version = this.stm.getVersion();
        PackageFriendlyConstructor o = new PackageFriendlyConstructor();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)o.value);
    }

    @Test
    public void testPrivateConstructor() {
        long version = this.stm.getVersion();
        PrivateConstructor o = new PrivateConstructor();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)o.value);
    }

    static class PrivateConstructor {
        private int value = 10;

        @TransactionalConstructor
        private PrivateConstructor() {
        }
    }

    static class PackageFriendlyConstructor {
        private int value = 10;

        @TransactionalConstructor
        PackageFriendlyConstructor() {
        }
    }

    static class ProtectedConstructor {
        private int value = 10;

        @TransactionalConstructor
        protected ProtectedConstructor() {
        }
    }

    static class FinalField {
        private int value;

        @TransactionalConstructor
        FinalField(int value) {
            this.value = value;
        }
    }

    static class PublicConstructor {
        private int value = 10;

        @TransactionalConstructor
        public PublicConstructor() {
        }
    }

    static class ConstructorWithCheckedException {
        @TransactionalConstructor
        ConstructorWithCheckedException(boolean throwIt) throws Exception {
            if (throwIt) {
                throw new Exception();
            }
        }
    }

    static class MultiArgTxConstructor {
        int arg1;
        int arg2;
        int arg3;
        int arg4;

        @TransactionalConstructor
        MultiArgTxConstructor(int arg1, int arg2, int arg3, int arg4) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }
    }

    static class SingleArgTxConstructor {
        int arg;

        @TransactionalConstructor
        SingleArgTxConstructor(int value) {
            this.arg = value;
        }
    }

    static class NoArgTxConstructor {
        int value = 20;

        @TransactionalConstructor
        NoArgTxConstructor() {
        }
    }
}

