/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class TransactionalMethod_ArgumentsTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @After
    public void tearDown() {
    }

    public static void assertTransactionWorking() {
        TestUtils.assertIsActive((Transaction[])new Transaction[]{ThreadLocalTransaction.getThreadLocalTransaction()});
    }

    @Test
    public void testNoArguments() {
        new NoArguments().doIt();
    }

    @Test
    public void objectArgument() {
        String arg = "foo";
        ObjectArgument a = new ObjectArgument();
        a.expectedArg1 = arg;
        a.doIt(arg);
    }

    @Test
    public void nullArgument() {
        Object arg = null;
        ObjectArgument a = new ObjectArgument();
        a.expectedArg1 = arg;
        a.doIt(arg);
    }

    @Test
    public void booleanArgument() {
        boolean arg = true;
        booleanArgument a = new booleanArgument();
        a.expectedArg1 = arg;
        a.doIt(arg);
    }

    @Test
    public void shortArgument() {
        short arg = 114;
        ShortArgument a = new ShortArgument();
        a.expectedArg1 = arg;
        a.doIt(arg);
    }

    @Test
    public void byteArgument() {
        byte arg = 114;
        ByteArgument a = new ByteArgument();
        a.expectedArg1 = arg;
        a.doIt(arg);
    }

    @Test
    public void intArgument() {
        int arg = 114;
        IntArgument a = new IntArgument();
        a.expectedArg1 = arg;
        a.doIt(arg);
    }

    @Test
    public void multipleIntArguments() {
        int arg1 = 114;
        int arg2 = 13243414;
        int arg3 = -2345114;
        MultipleIntArguments a = new MultipleIntArguments();
        a.expectedArg1 = arg1;
        a.expectedArg2 = arg2;
        a.expectedArg3 = arg3;
        a.doIt(arg1, arg2, arg3);
    }

    @Test
    public void longArgument() {
        long arg = 114L;
        LongArgument a = new LongArgument();
        a.expectedArg1 = arg;
        a.doIt(arg);
    }

    @Test
    public void multipleLongArguments() {
        long arg1 = 114L;
        long arg2 = 3423434324L;
        long arg3 = -29384734L;
        MultipleLongArguments a = new MultipleLongArguments();
        a.expectedArg1 = arg1;
        a.expectedArg2 = arg2;
        a.expectedArg3 = arg3;
        a.doIt(arg1, arg2, arg3);
    }

    @Test
    public void floatArgument() {
        float arg = 114.0f;
        FloatArgument a = new FloatArgument();
        a.expectedArg1 = arg;
        a.doIt(arg);
    }

    @Test
    public void doubleArgument() {
        double arg = 114.0;
        DoubleArgument a = new DoubleArgument();
        a.expectedArg1 = arg;
        a.doIt(arg);
    }

    @Test
    public void multipleDoubleArguments() {
        double arg1 = 114.0;
        double arg2 = 3.34334114E8;
        double arg3 = -3.837262114E9;
        MultipleDoubleArguments a = new MultipleDoubleArguments();
        a.expectedArg1 = arg1;
        a.expectedArg2 = arg2;
        a.expectedArg3 = arg3;
        a.doIt(arg1, arg2, arg3);
    }

    @Test
    public void complexSetOfArguments() {
        boolean arg1 = true;
        byte arg2 = 10;
        short arg3 = 20;
        char arg4 = 'a';
        int arg5 = 1245;
        long arg6 = 34945L;
        float arg7 = 3.14f;
        double arg8 = 6.2;
        String arg9 = "foobar";
        ComplexSetOfArguments a = new ComplexSetOfArguments();
        a.expectedArg1 = arg1;
        a.expectedArg2 = arg2;
        a.expectedArg3 = arg3;
        a.expectedArg4 = arg4;
        a.expectedArg5 = arg5;
        a.expectedArg6 = arg6;
        a.expectedArg7 = arg7;
        a.expectedArg8 = arg8;
        a.expectedArg9 = arg9;
        a.doIt(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    @Test
    public void primitiveArray() {
        PrimitiveArrayArgument a = new PrimitiveArrayArgument();
        PrimitiveArrayArgument.access$1702(a, new int[]{1, 2, 3});
        a.doIt(a.expectedArg);
    }

    @Test
    public void objectArray() {
        ObjectArrayArgument a = new ObjectArrayArgument();
        ObjectArrayArgument.access$1802(a, new Object[]{1, "foo", new Integer(20)});
        a.doIt(a.expectedArg);
    }

    @Test
    public void varArgsArgument() {
        VarArgsArgument a = new VarArgsArgument();
        VarArgsArgument.access$1902(a, new int[]{1, 2, 3});
        a.doIt(1, 2, 3);
    }

    @Test
    public void testStatic() {
        TransactionalInteger ref = new TransactionalInteger();
        long version = this.stm.getVersion();
        TransactionalMethod_ArgumentsTest.inc(ref);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @TransactionalMethod
    public static void inc(TransactionalInteger intRef2) {
        intRef2.inc();
    }

    public static class VarArgsArgument {
        private int[] expectedArg;

        @TransactionalMethod
        void doIt(int ... args) {
            Assert.assertEquals((long)args.length, (long)this.expectedArg.length);
            for (int k = 0; k < args.length; ++k) {
                Assert.assertEquals((long)this.expectedArg[k], (long)args[k]);
            }
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }

        static /* synthetic */ int[] access$1902(VarArgsArgument x0, int[] x1) {
            x0.expectedArg = x1;
            return x1;
        }
    }

    public static class ObjectArrayArgument {
        private Object[] expectedArg;

        @TransactionalMethod
        void doIt(Object[] args) {
            Assert.assertEquals((long)args.length, (long)this.expectedArg.length);
            for (int k = 0; k < args.length; ++k) {
                Assert.assertSame((Object)this.expectedArg[k], (Object)args[k]);
            }
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }

        static /* synthetic */ Object[] access$1802(ObjectArrayArgument x0, Object[] x1) {
            x0.expectedArg = x1;
            return x1;
        }
    }

    public static class PrimitiveArrayArgument {
        private int[] expectedArg;

        @TransactionalMethod
        void doIt(int[] args) {
            Assert.assertEquals((long)args.length, (long)this.expectedArg.length);
            for (int k = 0; k < args.length; ++k) {
                Assert.assertEquals((long)this.expectedArg[k], (long)args[k]);
            }
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }

        static /* synthetic */ int[] access$1702(PrimitiveArrayArgument x0, int[] x1) {
            x0.expectedArg = x1;
            return x1;
        }
    }

    public class ComplexSetOfArguments {
        boolean expectedArg1;
        byte expectedArg2;
        short expectedArg3;
        char expectedArg4;
        int expectedArg5;
        long expectedArg6;
        float expectedArg7;
        double expectedArg8;
        Object expectedArg9;

        @TransactionalMethod
        void doIt(boolean arg1, byte arg2, short arg3, char arg4, int arg5, long arg6, float arg7, Object arg8, Object arg9) {
            Assert.assertEquals((Object)this.expectedArg1, (Object)arg1);
            Assert.assertEquals((long)this.expectedArg2, (long)arg2);
            Assert.assertEquals((long)this.expectedArg3, (long)arg3);
            Assert.assertEquals((long)this.expectedArg4, (long)arg4);
            Assert.assertEquals((long)this.expectedArg5, (long)arg5);
            Assert.assertEquals((long)this.expectedArg6, (long)arg6);
            Assert.assertEquals((double)this.expectedArg7, (double)arg7, (double)1.0E-6);
            Assert.assertEquals((Object)this.expectedArg9, (Object)arg9);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class MultipleDoubleArguments {
        private double expectedArg1;
        private double expectedArg2;
        private double expectedArg3;

        @TransactionalMethod
        void doIt(double arg1, double arg2, double arg3) {
            Assert.assertEquals((double)this.expectedArg1, (double)arg1, (double)1.0E-6);
            Assert.assertEquals((double)this.expectedArg2, (double)arg2, (double)1.0E-6);
            Assert.assertEquals((double)this.expectedArg3, (double)arg3, (double)1.0E-6);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class DoubleArgument {
        private double expectedArg1;

        @TransactionalMethod
        void doIt(double arg1) {
            Assert.assertEquals((double)this.expectedArg1, (double)arg1, (double)1.0E-6);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class FloatArgument {
        private float expectedArg1;

        @TransactionalMethod
        void doIt(float arg1) {
            Assert.assertEquals((double)this.expectedArg1, (double)arg1, (double)1.0E-6);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class MultipleLongArguments {
        private long expectedArg1;
        private long expectedArg2;
        private long expectedArg3;

        @TransactionalMethod
        void doIt(long arg1, long arg2, long arg3) {
            Assert.assertEquals((long)this.expectedArg1, (long)arg1);
            Assert.assertEquals((long)this.expectedArg2, (long)arg2);
            Assert.assertEquals((long)this.expectedArg3, (long)arg3);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class LongArgument {
        private long expectedArg1;

        @TransactionalMethod
        void doIt(long arg1) {
            Assert.assertEquals((long)this.expectedArg1, (long)arg1);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class MultipleIntArguments {
        private int expectedArg1;
        private int expectedArg2;
        private int expectedArg3;

        @TransactionalMethod
        void doIt(int arg1, int arg2, int arg3) {
            Assert.assertEquals((long)this.expectedArg1, (long)arg1);
            Assert.assertEquals((long)this.expectedArg2, (long)arg2);
            Assert.assertEquals((long)this.expectedArg3, (long)arg3);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class IntArgument {
        private int expectedArg1;

        @TransactionalMethod
        void doIt(int arg1) {
            Assert.assertEquals((long)this.expectedArg1, (long)arg1);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class ByteArgument {
        private byte expectedArg1;

        @TransactionalMethod
        void doIt(byte arg1) {
            Assert.assertEquals((long)this.expectedArg1, (long)arg1);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class ShortArgument {
        private short expectedArg1;

        @TransactionalMethod
        void doIt(short arg1) {
            Assert.assertEquals((long)this.expectedArg1, (long)arg1);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class booleanArgument {
        private boolean expectedArg1;

        @TransactionalMethod
        void doIt(boolean arg1) {
            Assert.assertEquals((Object)this.expectedArg1, (Object)arg1);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class ObjectArgument {
        private Object expectedArg1;

        @TransactionalMethod
        void doIt(Object arg1) {
            Assert.assertSame((Object)this.expectedArg1, (Object)arg1);
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }

    public static class NoArguments {
        @TransactionalMethod
        void doIt() {
            TransactionalMethod_ArgumentsTest.assertTransactionWorking();
        }
    }
}

