/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.instrumentation.InstrumentationTestUtils;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class TransactionalMethod_InterfaceTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @After
    public void tearDown() {
        InstrumentationTestUtils.assertNoInstrumentationProblems();
    }

    @Test
    public void interfaceWithTransactionalMethod() {
        Class<InterfaceWithTransactionalMethod> clazz = InterfaceWithTransactionalMethod.class;
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"transactional", (Class[])new Class[0]));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"nontransactional", (Class[])new Class[0]));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"transactional___ro", (Class[])new Class[]{AlphaTransaction.class}));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"transactional___up", (Class[])new Class[]{AlphaTransaction.class}));
        Assert.assertFalse((boolean)TestUtils.hasMethod(clazz, (String)"nontransactional", (Class[])new Class[]{AlphaTransaction.class}));
    }

    @Test
    public void transactionalInterface() {
        Class<TransactionalInterface> clazz = TransactionalInterface.class;
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"explitTransactional", (Class[])new Class[0]));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"implicitTransactional", (Class[])new Class[0]));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"explitTransactional___ro", (Class[])new Class[]{AlphaTransaction.class}));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"explitTransactional___up", (Class[])new Class[]{AlphaTransaction.class}));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"implicitTransactional___ro", (Class[])new Class[]{AlphaTransaction.class}));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"implicitTransactional___up", (Class[])new Class[]{AlphaTransaction.class}));
    }

    @Test
    public void InterfaceExtendingTransactionalInterface() {
        Class<TransactionalInterface> clazz = TransactionalInterface.class;
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"explitTransactional", (Class[])new Class[0]));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"implicitTransactional", (Class[])new Class[0]));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"explitTransactional___ro", (Class[])new Class[]{AlphaTransaction.class}));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"explitTransactional___up", (Class[])new Class[]{AlphaTransaction.class}));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"implicitTransactional___ro", (Class[])new Class[]{AlphaTransaction.class}));
        Assert.assertTrue((boolean)TestUtils.hasMethod(clazz, (String)"implicitTransactional___up", (Class[])new Class[]{AlphaTransaction.class}));
    }

    @Test
    @Ignore
    public void interfaceOverridingTransactionalMethod() {
    }

    @TransactionalObject
    static interface InterfaceExtendingTransactionalInterface
    extends TransactionalInterface {
    }

    @TransactionalObject
    static interface TransactionalInterface {
        @TransactionalMethod
        public void explitTransactional();

        public void implicitTransactional();
    }

    static interface InterfaceWithTransactionalMethod {
        @TransactionalMethod
        public void transactional();

        public void nontransactional();
    }
}

