/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalMethod_ReadonlyTransactionTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void whenReadIsDone() {
        intRef ref = new intRef(10);
        long version = this.stm.getVersion();
        int value = ref.get();
        Assert.assertEquals((long)10L, (long)value);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenUpdateDone_thenReadonlyException() {
        intRef ref = new intRef(10);
        long version = this.stm.getVersion();
        try {
            ref.readonlySet(11);
            Assert.fail();
        }
        catch (ReadonlyException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @TransactionalObject
    static class intRef {
        private int value;

        intRef(int value) {
            this.value = value;
        }

        @TransactionalMethod(readonly=true)
        public int get() {
            return this.value;
        }

        @TransactionalMethod(readonly=true)
        public void readonlySet(int value) {
            this.value = value;
        }

        public void set(int value) {
            this.value = value;
        }
    }
}

