/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class TransactionalMethod_StaticMethodTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @After
    public void tearDown() {
    }

    public static void assertTransactionWorking() {
        TestUtils.assertIsActive((Transaction[])new Transaction[]{ThreadLocalTransaction.getThreadLocalTransaction()});
    }

    @Test
    public void testSimpleStaticMethod() {
        long version = this.stm.getVersion();
        StaticNoArgMethod.doIt();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void testComplexStaticMethod() {
        StaticComplexMethod.aExpected = 10;
        StaticComplexMethod.bExpected = 1000L;
        StaticComplexMethod.cExpected = "";
        StaticComplexMethod.result = 400;
        int result = StaticComplexMethod.doIt(StaticComplexMethod.aExpected, StaticComplexMethod.bExpected, StaticComplexMethod.cExpected);
        Assert.assertEquals((long)StaticComplexMethod.result, (long)result);
    }

    @Test
    public void atomicObjectsArePassedToStaticMethod() {
        TransactionalInteger a = new TransactionalInteger(10);
        TransactionalInteger b = new TransactionalInteger(20);
        long version = this.stm.getVersion();
        TransactionalMethod_StaticMethodTest.swap(a, b);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)20L, (long)a.get());
        Assert.assertEquals((long)10L, (long)b.get());
    }

    @TransactionalMethod
    public static void swap(TransactionalInteger a, TransactionalInteger b) {
        int oldA = a.get();
        a.set(b.get());
        b.set(oldA);
    }

    public static class StaticComplexMethod {
        static int aExpected;
        static long bExpected;
        static String cExpected;
        static int result;

        @TransactionalMethod
        static int doIt(int a, long b, String c) {
            TransactionalMethod_StaticMethodTest.assertTransactionWorking();
            Assert.assertEquals((long)aExpected, (long)a);
            Assert.assertEquals((long)bExpected, (long)b);
            Assert.assertSame((Object)cExpected, (Object)c);
            return result;
        }
    }

    public static class StaticNoArgMethod {
        @TransactionalMethod
        static void doIt() {
            TransactionalMethod_StaticMethodTest.assertTransactionWorking();
        }
    }
}

