/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.NoTransactionFoundException;
import org.multiverse.instrumentation.InstrumentationTestUtils;
import org.multiverse.javaagent.JavaAgentProblemMonitor;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalObject_ExcludeMethodTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
    }

    @After
    public void tearDown() {
        Assert.assertFalse((boolean)JavaAgentProblemMonitor.INSTANCE.isProblemFound());
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenExcludeMethodIsCombinedWithExplicitTransactionalMethod_thenTransactionalMethodIgnored() {
        ExcludePriorityObject o = new ExcludePriorityObject();
        long version = this.stm.getVersion();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        o.excludedIncTwice();
        Assert.assertEquals((long)2L, (long)o.get());
        Assert.assertEquals((long)(version + 2L), (long)this.stm.getVersion());
    }

    @Test(expected=NoTransactionFoundException.class)
    public void whenExcludedInstanceMethodAccessesTransactionalField_thenNoTransactionFoundException() {
        ObjectForFieldAccess o = new ObjectForFieldAccess();
        o.inc();
    }

    @Test
    public void whenExcludedMethodWithDirectFieldAccessIsWrappedInTransaction_thenNoProblems() {
        ObjectForFieldAccess o = new ObjectForFieldAccess();
        long version = this.stm.getVersion();
        o.wrappingExcludedInc();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.get());
    }

    @Test
    public void whenTransactionWrappedAroundExcludedMethod_thenTransactionIsJoined() {
        SomeObject object = new SomeObject();
        long version = this.stm.getVersion();
        object.wrappingExcludedIncTwice();
        Assert.assertEquals((long)2L, (long)object.get());
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
    }

    @Test
    public void whenMethodExcludedOnNonTransactionalObject_thenIgnored() {
        NonTransactionalObject o = new NonTransactionalObject();
        long version = this.stm.getVersion();
        o.someMethod();
        Assert.assertEquals((long)1L, (long)o.value);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenMultipleTransactionalCallsAreDone_thenMultipleTransactionsStarted() {
        SomeObject object = new SomeObject();
        long version = this.stm.getVersion();
        object.excludedIncTwice();
        Assert.assertEquals((long)2L, (long)object.get());
        Assert.assertEquals((long)(version + 2L), (long)this.stm.getVersion());
    }

    @TransactionalObject
    public static class SomeObject {
        private int value;

        public void inc() {
            ++this.value;
        }

        public int get() {
            return this.value;
        }

        @NonTransactional
        public void excludedIncTwice() {
            this.inc();
            this.inc();
        }

        public void wrappingExcludedIncTwice() {
            this.excludedIncTwice();
        }
    }

    public static class NonTransactionalObject {
        private int value;

        @NonTransactional
        public void someMethod() {
            ++this.value;
        }
    }

    @TransactionalObject
    public static class ObjectForFieldAccess {
        private int value;

        @NonTransactional
        public void inc() {
            ++this.value;
        }

        public void wrappingExcludedInc() {
            this.inc();
        }

        public int get() {
            return this.value;
        }
    }

    @TransactionalObject
    public static class ExcludePriorityObject {
        private int value;

        public void inc() {
            ++this.value;
        }

        public int get() {
            return this.value;
        }

        @NonTransactional
        public void excludedIncTwice() {
            this.inc();
            this.inc();
        }
    }
}

