/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.instrumentation.AlphaReflectionUtils;

public class TransactionalObject_FieldTypesTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testVolatile() {
        VolatileField o = new VolatileField();
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsField(VolatileField.class, "field"));
    }

    @Test
    public void testTransient() {
        TransientField o = new TransientField();
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
        Field transientField = AlphaReflectionUtils.getTranlocalField(TransientField.class, "field");
        Assert.assertTrue((boolean)Modifier.isTransient(transientField.getModifiers()));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(TransientField.class, "field"));
    }

    @Test
    public void noFieldsTest() {
        NoFields value = new NoFields();
        Assert.assertFalse((boolean)(value instanceof AlphaTransactionalObject));
    }

    @Test
    public void booleanTest() {
        booleanValue value = new booleanValue(true);
        Assert.assertTrue((boolean)value.get());
        value.set(false);
        Assert.assertFalse((boolean)value.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(booleanValue.class, "value"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(TransientField.class, "value"));
    }

    @Test
    public void shortTest() {
        shortValue value = new shortValue(10);
        Assert.assertEquals((long)10L, (long)value.get());
        value.set((short)20);
        Assert.assertEquals((long)20L, (long)value.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(shortValue.class, "value"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(shortValue.class, "value"));
    }

    @Test
    public void byteTest() {
        byteValue value = new byteValue(10);
        Assert.assertEquals((long)10L, (long)value.get());
        value.set((byte)20);
        Assert.assertEquals((long)20L, (long)value.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(byteValue.class, "value"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(byteValue.class, "value"));
    }

    @Test
    public void charTest() {
        charValue value = new charValue('a');
        Assert.assertEquals((long)97L, (long)value.get());
        value.set('b');
        Assert.assertEquals((long)98L, (long)value.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(charValue.class, "value"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(charValue.class, "value"));
    }

    @Test
    public void intTest() {
        intValue value = new intValue(10);
        Assert.assertEquals((long)10L, (long)value.get());
        value.set(20);
        Assert.assertEquals((long)20L, (long)value.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(intValue.class, "value"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(intValue.class, "value"));
    }

    @Test
    public void floatTest() {
        floatValue value = new floatValue(10.0f);
        Assert.assertEquals((double)10.0, (double)value.get(), (double)1.0E-6);
        value.set(20.0f);
        Assert.assertEquals((double)20.0, (double)value.get(), (double)1.0E-6);
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(floatValue.class, "value"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(floatValue.class, "value"));
    }

    @Test
    public void longTest() {
        longValue value = new longValue(10L);
        Assert.assertEquals((long)10L, (long)value.get());
        value.set(20L);
        Assert.assertEquals((long)20L, (long)value.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(longValue.class, "value"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(longValue.class, "value"));
    }

    @Test
    public void doubleTest() {
        doubleValue value = new doubleValue(10.0);
        Assert.assertEquals((double)10.0, (double)value.get(), (double)1.0E-6);
        value.set(20.0);
        Assert.assertEquals((double)20.0, (double)value.get(), (double)1.0E-6);
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(doubleValue.class, "value"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(doubleValue.class, "value"));
    }

    @Test
    public void nonTransactionalObjectRefTest() {
        String value1 = "foo";
        NonTransactionalObjectRef ref = new NonTransactionalObjectRef(value1);
        Assert.assertEquals((Object)value1, (Object)ref.get());
        String value2 = "bar";
        ref.set(value2);
        Assert.assertEquals((Object)value2, (Object)ref.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(NonTransactionalObjectRef.class, "ref"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(NonTransactionalObjectRef.class, "ref"));
    }

    @Test
    public void nonTransactionalObjectRefWithNullTest() {
        NonTransactionalObjectRef ref = new NonTransactionalObjectRef(null);
        Assert.assertEquals(null, (Object)ref.get());
        String value = "foo";
        ref.set(value);
        Assert.assertEquals((Object)value, (Object)ref.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(NonTransactionalObjectRef.class, "ref"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(NonTransactionalObjectRef.class, "ref"));
    }

    @Test
    public void transactionalObjectRefTest() {
        intValue value1 = new intValue(10);
        TransactionalObjectRef ref = new TransactionalObjectRef(value1);
        Assert.assertSame((Object)value1, (Object)ref.get());
        intValue value2 = new intValue(20);
        ref.set(value2);
        Assert.assertEquals((Object)value2, (Object)ref.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(TransactionalObjectRef.class, "ref"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(TransactionalObjectRef.class, "ref"));
    }

    @Test
    public void transactionalObjectRefWithNullTest() {
        TransactionalObjectRef ref = new TransactionalObjectRef(null);
        Assert.assertEquals(null, (Object)ref.get());
        intValue value = new intValue(10);
        ref.set(value);
        Assert.assertEquals((Object)value, (Object)ref.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(TransactionalObjectRef.class, "ref"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(TransactionalObjectRef.class, "ref"));
    }

    @Test
    public void runtimeKnownRefType_atomicObjectType() {
        intValue value1 = new intValue(10);
        RuntimeKnownObjectRef ref = new RuntimeKnownObjectRef(value1);
        Assert.assertSame((Object)value1, (Object)ref.get());
        intValue value2 = new intValue(20);
        ref.set(value2);
        Assert.assertEquals((Object)value2, (Object)ref.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(RuntimeKnownObjectRef.class, "ref"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(RuntimeKnownObjectRef.class, "ref"));
    }

    @Test
    public void runtimeKnownRefType_nullValue() {
        TransactionalObjectRef ref = new TransactionalObjectRef(null);
        Assert.assertEquals(null, (Object)ref.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(TransactionalObjectRef.class, "ref"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(TransactionalObjectRef.class, "ref"));
    }

    @Test
    public void runtimeKnownRefType_nonAtomicObjectValue() {
        String value1 = "foo";
        RuntimeKnownObjectRef ref = new RuntimeKnownObjectRef(value1);
        Assert.assertSame((Object)value1, (Object)ref.get());
        String value2 = "bar";
        ref.set(value2);
        Assert.assertEquals((Object)value2, (Object)ref.get());
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(RuntimeKnownObjectRef.class, "ref"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(RuntimeKnownObjectRef.class, "ref"));
    }

    @TransactionalObject
    public static class RuntimeKnownObjectRef {
        private Object ref;

        public RuntimeKnownObjectRef(Object ref) {
            this.ref = ref;
        }

        public Object get() {
            return this.ref;
        }

        public void set(Object value) {
            this.ref = value;
        }
    }

    @TransactionalObject
    public static class TransactionalObjectRef {
        private intValue ref;

        public TransactionalObjectRef(intValue ref) {
            this.ref = ref;
        }

        public intValue get() {
            return this.ref;
        }

        public void set(intValue value) {
            this.ref = value;
        }
    }

    @TransactionalObject
    public static class NonTransactionalObjectRef {
        private String ref;

        public NonTransactionalObjectRef(String value) {
            this.ref = value;
        }

        public String get() {
            return this.ref;
        }

        public void set(String value) {
            this.ref = value;
        }
    }

    @TransactionalObject
    public static class doubleValue {
        private double value;

        public doubleValue(double value) {
            this.value = value;
        }

        public double get() {
            return this.value;
        }

        public void set(double value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class longValue {
        private long value;

        public longValue(long value) {
            this.value = value;
        }

        public long get() {
            return this.value;
        }

        public void set(long value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class floatValue {
        private float value;

        public floatValue(float value) {
            this.value = value;
        }

        public float get() {
            return this.value;
        }

        public void set(float value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class intValue {
        private int value;

        public intValue(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class charValue {
        private char value;

        public charValue(char value) {
            this.value = value;
        }

        public char get() {
            return this.value;
        }

        public void set(char value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class byteValue {
        private byte value;

        public byteValue(byte value) {
            this.value = value;
        }

        public byte get() {
            return this.value;
        }

        public void set(byte value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class shortValue {
        private short value;

        public shortValue(short value) {
            this.value = value;
        }

        public short get() {
            return this.value;
        }

        public void set(short value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class booleanValue {
        private boolean value;

        public booleanValue(boolean value) {
            this.value = value;
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class NoFields {
    }

    @TransactionalObject
    public static class TransientField {
        transient int field;
    }

    @TransactionalObject
    public static class VolatileField {
        volatile int field;
    }
}

