/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class TransactionalObject_MethodTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void txObjectAsReturnValue() {
        TxObjectAsReturnValue child = new TxObjectAsReturnValue();
        TxObjectAsReturnValue parent = new TxObjectAsReturnValue();
        long version = this.stm.getVersion();
        child.setRef(parent);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)parent, (Object)child.getRef());
        Assert.assertNull((Object)parent.getRef());
    }

    @Test
    public void testRuntimeKnownReturnTypeWithNonTxObject() {
        String item = "foo";
        ObjectReturn objectReturn = new ObjectReturn(item);
        Assert.assertSame((Object)item, (Object)objectReturn.doIt());
    }

    @Test
    public void testRuntimeKnownReturnTypeWithTxObject() {
        TransactionalInteger item = new TransactionalInteger();
        ObjectReturn objectReturn = new ObjectReturn(item);
        Assert.assertSame((Object)item, (Object)objectReturn.doIt());
    }

    @Test
    public void testNonTxObjectReturnValue() {
        String value = "foo";
        StringReturn r = new StringReturn(value);
        Assert.assertSame((Object)value, (Object)r.doIt());
    }

    @Test
    public void testNonTxObjectReturnValueThatIsNull() {
        StringReturn r = new StringReturn(null);
        Assert.assertNull((Object)r.doIt());
    }

    @Test
    public void booleanReturnValue() {
        BooleanReturn b = new BooleanReturn(true);
        Assert.assertTrue((boolean)b.doIt());
    }

    @Test
    public void shortReturnValue() {
        shortReturn shortReturn2 = new shortReturn(100);
        Assert.assertEquals((long)100L, (long)shortReturn2.doIt());
    }

    @Test
    public void byteReturnValue() {
        byteReturn byteReturn2 = new byteReturn(100);
        Assert.assertEquals((long)100L, (long)byteReturn2.doIt());
    }

    @Test
    public void charReturnValue() {
        charReturn charReturn2 = new charReturn('d');
        Assert.assertEquals((long)100L, (long)charReturn2.doIt());
    }

    @Test
    public void intReturnValue() {
        intReturn intReturn2 = new intReturn(100);
        Assert.assertEquals((long)100L, (long)intReturn2.doIt());
    }

    @Test
    public void floatReturnValue() {
        floatReturn floatReturn2 = new floatReturn(100.0f);
        Assert.assertEquals((double)100.0, (double)floatReturn2.doIt(), (double)1.0E-5);
    }

    @Test
    public void longReturnValue() {
        longReturn longReturn2 = new longReturn(100L);
        Assert.assertEquals((long)100L, (long)longReturn2.doIt());
    }

    @Test
    public void doubleReturnValue() {
        doubleReturn doubleReturn2 = new doubleReturn(100.0);
        Assert.assertEquals((double)100.0, (double)doubleReturn2.doIt(), (double)1.0E-5);
    }

    @Test
    public void booleanArg() {
        booleanArg booleanArg2 = new booleanArg();
        booleanArg2.doIt(true);
        Assert.assertTrue((boolean)booleanArg2.getArg());
        booleanArg2.doIt(false);
        Assert.assertFalse((boolean)booleanArg2.getArg());
    }

    @Test
    public void charArg() {
        charArg charArg2 = new charArg();
        charArg2.doIt('\u0014');
        Assert.assertEquals((long)20L, (long)charArg2.getArg());
    }

    @Test
    public void byteArg() {
        byteArg byteArg2 = new byteArg();
        byteArg2.doIt((byte)20);
        Assert.assertEquals((long)20L, (long)byteArg2.getArg());
    }

    @Test
    public void shortArg() {
        shortArg shortArg2 = new shortArg();
        shortArg2.doIt((short)20);
        Assert.assertEquals((long)20L, (long)shortArg2.getArg());
    }

    @Test
    public void intArg() {
        intArg intArg2 = new intArg();
        intArg2.doIt(20);
        Assert.assertEquals((long)20L, (long)intArg2.getArg());
    }

    @Test
    public void floatArg() {
        floatArg floatArg2 = new floatArg();
        floatArg2.doIt(20.0f);
        Assert.assertEquals((double)20.0, (double)floatArg2.getArg(), (double)1.0E-6);
    }

    @Test
    public void longArg() {
        longArg longArg2 = new longArg();
        longArg2.doIt(20L);
        Assert.assertEquals((long)20L, (long)longArg2.getArg());
    }

    @Test
    public void doubleArg() {
        doubleArg doubleArg2 = new doubleArg();
        doubleArg2.doIt(20.0);
        Assert.assertEquals((double)20.0, (double)doubleArg2.getArg(), (double)1.0E-4);
    }

    @Test
    public void arrayArg() {
        int[] array = new int[]{1, 2, 3, 4};
        arrayArg arrayArg2 = new arrayArg();
        arrayArg2.doIt(array);
        Assert.assertSame((Object)array, (Object)arrayArg2.getArg());
        arrayArg2.doIt(null);
        Assert.assertNull((Object)arrayArg2.getArg());
    }

    @Test
    public void varArgs() {
        int[] array = new int[]{1, 2, 3, 4};
        varArg arrayArg2 = new varArg();
        arrayArg2.doIt(array);
        Assert.assertSame((Object)array, (Object)arrayArg2.getArg());
        arrayArg2.doIt(null);
        Assert.assertNull((Object)arrayArg2.getArg());
    }

    @Test
    public void nonTxObjectArg() {
        String arg = "foo";
        NonTxObjectArg nonTxObjectArg = new NonTxObjectArg();
        nonTxObjectArg.doIt(arg);
        Assert.assertSame((Object)arg, (Object)nonTxObjectArg.getArg());
        nonTxObjectArg.doIt(null);
        Assert.assertNull((Object)nonTxObjectArg.getArg());
    }

    @Test
    public void txObjectAsArgument() {
        TxObjectArg o = new TxObjectArg();
        o.inc();
        Assert.assertEquals((long)1L, (long)o.getRef().get());
    }

    @Test
    public void runtimeKnownArg() {
        RuntimeKnownArg runtimeKnownArg = new RuntimeKnownArg();
        NonTxObjectRunnable firstValue = new NonTxObjectRunnable();
        runtimeKnownArg.doIt(firstValue);
        Assert.assertSame((Object)firstValue, (Object)runtimeKnownArg.getArg());
        Assert.assertEquals((long)1L, (long)firstValue.getValue());
        TxObjectRunnable secondValue = new TxObjectRunnable();
        runtimeKnownArg.doIt(secondValue);
        Assert.assertSame((Object)secondValue, (Object)runtimeKnownArg.getArg());
        Assert.assertEquals((long)1L, (long)secondValue.getValue());
    }

    @Test
    public void txObjectIsCreatedInMethod() {
        TxObjectIsCreatedInMethod o = new TxObjectIsCreatedInMethod();
        long version = this.stm.getVersion();
        o.doIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)20L, (long)o.getRef().get());
    }

    @Test
    public void txObjectAsArgumentProblem() {
        TxObjectArgProblem o1 = new TxObjectArgProblem(1);
        TxObjectArgProblem o2 = new TxObjectArgProblem(2);
        o1.method1(o2);
        Assert.assertEquals((long)1L, (long)o1.getSomefield());
        Assert.assertEquals((long)1L, (long)o2.getSomefield());
    }

    @TransactionalObject
    static class TxObjectArgProblem {
        protected int somefield;

        TxObjectArgProblem(int somefield) {
            this.somefield = somefield;
        }

        public int getSomefield() {
            return this.somefield;
        }

        public void method2(TxObjectArgProblem ref) {
            this.somefield = ref.somefield;
        }

        public void method1(TxObjectArgProblem ref) {
            ref.method2(this);
        }
    }

    @TransactionalObject
    static class TxObjectIsCreatedInMethod {
        private TransactionalInteger ref;

        TxObjectIsCreatedInMethod() {
        }

        public void doIt() {
            this.ref = new TransactionalInteger(20);
        }

        public TransactionalInteger getRef() {
            return this.ref;
        }
    }

    @TransactionalObject
    static class RuntimeKnownArg {
        Runnable arg;

        RuntimeKnownArg() {
        }

        public void doIt(Runnable arg) {
            this.arg = arg;
            arg.run();
        }

        public Runnable getArg() {
            return this.arg;
        }
    }

    class NonTxObjectRunnable
    implements Runnable {
        int value;

        NonTxObjectRunnable() {
        }

        @Override
        public void run() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class TxObjectRunnable
    implements Runnable {
        int value = 0;

        @Override
        public void run() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class TxObjectArg {
        private TransactionalInteger ref = new TransactionalInteger(0);

        public void inc() {
            this.doIt(this.ref);
        }

        public void doIt(TransactionalInteger intRef2) {
            intRef2.inc();
        }

        public TransactionalInteger getRef() {
            return this.ref;
        }
    }

    @TransactionalObject
    public static class NonTxObjectArg {
        private String arg;

        public void doIt(String arg) {
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    public static class varArg {
        int[] arg;

        public void doIt(int ... arg) {
            this.arg = arg;
        }

        public int[] getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    public static class arrayArg {
        int[] arg;

        public void doIt(int[] arg) {
            this.arg = arg;
        }

        public int[] getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    public static class doubleArg {
        double arg;

        public void doIt(double arg) {
            this.arg = arg;
        }

        public double getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    public static class longArg {
        long arg;

        public void doIt(long arg) {
            this.arg = arg;
        }

        public long getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    public static class floatArg {
        float arg;

        public void doIt(float arg) {
            this.arg = arg;
        }

        public float getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    static class intArg {
        int arg;

        intArg() {
        }

        public void doIt(int arg) {
            this.arg = arg;
        }

        public int getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    public static class shortArg {
        short arg;

        public void doIt(short arg) {
            this.arg = arg;
        }

        public short getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    public static class byteArg {
        byte arg;

        public void doIt(byte arg) {
            this.arg = arg;
        }

        public byte getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    public static class charArg {
        char arg;

        public void doIt(char arg) {
            this.arg = arg;
        }

        public char getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    public static class booleanArg {
        boolean arg;

        public void doIt(boolean arg) {
            this.arg = arg;
        }

        public boolean getArg() {
            return this.arg;
        }
    }

    @TransactionalObject
    private static class doubleReturn {
        private double value;

        private doubleReturn(double value) {
            this.value = value;
        }

        public double theMethod() {
            return this.value;
        }

        public double doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    private static class longReturn {
        private long value;

        private longReturn(long value) {
            this.value = value;
        }

        public long theMethod() {
            return this.value;
        }

        public long doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    private static class floatReturn {
        private float value;

        private floatReturn(float value) {
            this.value = value;
        }

        public float theMethod() {
            return this.value;
        }

        public float doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    private static class intReturn {
        private int value;

        private intReturn(int value) {
            this.value = value;
        }

        public int theMethod() {
            return this.value;
        }

        public int doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    private static class charReturn {
        private char value;

        private charReturn(char value) {
            this.value = value;
        }

        public char theMethod() {
            return this.value;
        }

        public char doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    private static class byteReturn {
        private byte value;

        private byteReturn(byte value) {
            this.value = value;
        }

        public byte theMethod() {
            return this.value;
        }

        public byte doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    private static class shortReturn {
        private short value;

        private shortReturn(short value) {
            this.value = value;
        }

        public short theMethod() {
            return this.value;
        }

        public short doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    private static class BooleanReturn {
        private boolean value;

        private BooleanReturn(boolean value) {
            this.value = value;
        }

        public boolean theMethod() {
            return this.value;
        }

        public boolean doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    private static class StringReturn {
        private String value;

        private StringReturn(String value) {
            this.value = value;
        }

        public String theMethod() {
            return this.value;
        }

        public String doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    private static class ObjectReturn {
        private Object value;

        private ObjectReturn(Object value) {
            this.value = value;
        }

        public Object theMethod() {
            return this.value;
        }

        public Object doIt() {
            return this.theMethod();
        }
    }

    @TransactionalObject
    static class TxObjectAsReturnValue {
        private TxObjectAsReturnValue ref;

        public TxObjectAsReturnValue() {
            this.ref = null;
        }

        public TxObjectAsReturnValue(TxObjectAsReturnValue ref) {
            this.ref = ref;
        }

        public TxObjectAsReturnValue getRef() {
            return this.ref;
        }

        public void setRef(TxObjectAsReturnValue ref) {
            this.ref = ref;
        }
    }
}

