/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.integrationtest;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.Stack;

@TransactionalObject
public class Queue<E> {
    public final Stack<E> pushedStack;
    public final Stack<E> readyToPopStack;
    public final int maxCapacity;

    public Queue(int maxCapacity) {
        if (maxCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.pushedStack = new Stack();
        this.readyToPopStack = new Stack();
        this.maxCapacity = maxCapacity;
    }

    public Queue() {
        this.pushedStack = new Stack();
        this.readyToPopStack = new Stack();
        this.maxCapacity = Integer.MAX_VALUE;
    }

    @TransactionalMethod(readonly=true)
    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void push(E item) {
        if (this.size() > this.maxCapacity) {
            throw new IllegalStateException();
        }
        this.pushedStack.push(item);
    }

    public E take() {
        if (this.readyToPopStack.isEmpty()) {
            while (!this.pushedStack.isEmpty()) {
                this.readyToPopStack.push(this.pushedStack.pop());
            }
        }
        return this.readyToPopStack.pop();
    }

    @TransactionalMethod(readonly=true)
    public int size() {
        return this.pushedStack.size() + this.readyToPopStack.size();
    }

    @TransactionalMethod(readonly=true)
    public boolean isEmpty() {
        return this.pushedStack.isEmpty() && this.readyToPopStack.isEmpty();
    }
}

