/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.integrationtest;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.instrumentation.InstrumentationTestUtils;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.instrumentation.AlphaReflectionUtils;
import org.multiverse.stms.alpha.instrumentation.integrationtest.Stack;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.templates.TransactionTemplate;

public class StackTest {
    private AlphaStm stm;
    private TransactionFactory updateTxFactory;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build();
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
    }

    @After
    public void tearDown() {
        InstrumentationTestUtils.assertNoInstrumentationProblems();
    }

    @Test
    public void testStructuralContent() {
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(Stack.class, "size"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(Stack.class, "head"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalClass(Stack.class));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(Stack.class, "size"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(Stack.class, "head"));
    }

    @Test
    public void testIsTransformed() {
        Stack stack = new Stack();
        Assert.assertTrue((boolean)(stack instanceof AlphaTransactionalObject));
    }

    @Test
    public void readUncommitted() {
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                Stack stack = new Stack();
                AlphaTransaction alphaTransaction = (AlphaTransaction)t;
                AlphaTranlocal tranlocal = alphaTransaction.openForWrite((AlphaTransactionalObject)stack);
                Assert.assertFalse((boolean)tranlocal.isCommitted());
                Assert.assertSame(stack, (Object)tranlocal.getTransactionalObject());
                return null;
            }
        }.execute();
    }

    @Test
    public void readCommitted() {
        final Stack<String> stack = new Stack<String>();
        stack.push("foo");
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                AlphaTransaction alphaTransaction = (AlphaTransaction)t;
                AlphaTranlocal tranlocal = alphaTransaction.openForWrite((AlphaTransactionalObject)stack);
                Assert.assertFalse((boolean)tranlocal.isCommitted());
                Assert.assertSame((Object)stack, (Object)tranlocal.getTransactionalObject());
                return null;
            }
        }.execute();
    }

    @Test
    public void readReadonly() {
        final Stack stack = new Stack();
        AlphaTransactionalObject transactionalObject = (AlphaTransactionalObject)stack;
        final AlphaTranlocal storedTranlocal = transactionalObject.___load();
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setReadonly(true).build();
        new TransactionTemplate(txFactory){

            public Object execute(Transaction t) throws Exception {
                AlphaTransaction alphaTransaction = (AlphaTransaction)t;
                AlphaTranlocal tranlocal = alphaTransaction.openForRead((AlphaTransactionalObject)stack);
                Assert.assertEquals((long)StackTest.this.stm.getVersion(), (long)tranlocal.getWriteVersion());
                Assert.assertSame((Object)storedTranlocal, (Object)tranlocal);
                Assert.assertSame((Object)stack, (Object)tranlocal.getTransactionalObject());
                return null;
            }
        }.execute();
    }

    @Test
    public void testCreation() {
        long version = this.stm.getVersion();
        Stack stack = new Stack();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)0L, (long)stack.size());
    }

    @Test
    public void testPush() {
        Stack<Integer> stack = new Stack<Integer>();
        long version = this.stm.getVersion();
        stack.push(1);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertFalse((boolean)stack.isEmpty());
        Assert.assertEquals((long)1L, (long)stack.size());
    }

    @Test
    public void popFromNonEmptyStack() {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(10);
        long version = this.stm.getVersion();
        int result = (Integer)stack.pop();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)result);
        Assert.assertEquals((long)0L, (long)stack.size());
    }

    @Test
    public void clearOfNonEmptyStack() {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(10);
        long version = this.stm.getVersion();
        stack.clear();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)stack.size());
    }

    @Test
    public void clearOfEmptyStack() {
        Stack stack = new Stack();
        long version = this.stm.getVersion();
        stack.clear();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)stack.isEmpty());
    }

    @Test
    public void testRollback() {
        Stack<String> stack = new Stack<String>();
        long version = this.stm.getVersion();
        Transaction t = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        stack.push("foo");
        stack.push("bar");
        t.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)stack.isEmpty());
    }
}

