/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.OptimisticLockFailedWriteConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTestUtils;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.IntRef;
import org.multiverse.stms.alpha.manualinstrumentation.IntRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class AbaProblemOverMultipleTransactionsIsDetectedTest {
    private static final int A = 1;
    private static final int B = 2;
    private static final int C = 3;
    private AlphaStm stm;
    private IntRef ref;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        this.ref = new IntRef(1);
    }

    public AlphaTransaction startUpdateTransaction() {
        AlphaTransaction t = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void test() {
        AlphaTransaction t1 = this.startUpdateTransaction();
        IntRefTranlocal r1 = (IntRefTranlocal)t1.openForWrite((AlphaTransactionalObject)this.ref);
        AlphaTransaction t2 = this.startUpdateTransaction();
        IntRefTranlocal r2 = (IntRefTranlocal)t2.openForWrite((AlphaTransactionalObject)this.ref);
        this.ref.set(r2, 2);
        t2.commit();
        AlphaTransaction t3 = this.startUpdateTransaction();
        IntRefTranlocal r3 = (IntRefTranlocal)t3.openForWrite((AlphaTransactionalObject)this.ref);
        this.ref.set(r3, 2);
        t3.commit();
        this.ref.set(r1, 3);
        try {
            t1.commit();
            Assert.fail();
        }
        catch (OptimisticLockFailedWriteConflict er) {
            // empty catch block
        }
    }
}

