/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.transactional.DefaultTransactionalReference;

public class OpenTest {
    private AlphaStm stm;
    private static DefaultTransactionalReference<Integer> ref;

    @Before
    public void setUp() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ref = new DefaultTransactionalReference((Object)0);
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void testOpenForWrite() {
        OpenTest.executeUpdate();
    }

    @TransactionalMethod
    public static void executeUpdate() {
        AlphaTransaction t = (AlphaTransaction)ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        AlphaTranlocal tranlocal = t.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)tranlocal.isUncommitted());
        Assert.assertEquals((long)0L, (long)((Integer)ref.get()).intValue());
    }

    @Test
    public void testOpenForRead() {
        OpenTest.executeReadonly();
    }

    @TransactionalMethod(readonly=true)
    public static void executeReadonly() {
        AlphaTransaction t = (AlphaTransaction)ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        AlphaTranlocal tranlocal = t.openForRead((AlphaTransactionalObject)ref);
        Assert.assertEquals((long)0L, (long)((Integer)ref.get()).intValue());
    }
}

