/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.transactional.DefaultTransactionalReference;

public class ReadonlyTransactionTest {
    private static AlphaStm stm;

    @Before
    public void setUp() {
        stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void refIsTransformed() {
        DefaultTransactionalReference ref = new DefaultTransactionalReference();
        Assert.assertTrue((boolean)(ref instanceof AlphaTransactionalObject));
    }

    @Test
    public void whenNonTrackingRead_thenReadonlyOperationSucceeds() {
        DefaultTransactionalReference ref = new DefaultTransactionalReference((Object)10);
        long version = stm.getVersion();
        ReadonlyTransactionTest.executeNonTrackingReadonlyMethod((DefaultTransactionalReference<Integer>)ref, 10);
        Assert.assertEquals((long)version, (long)stm.getVersion());
    }

    @TransactionalMethod(readonly=true)
    public static void executeNonTrackingReadonlyMethod(DefaultTransactionalReference<Integer> ref, int expectedValue) {
        Assert.assertEquals((long)expectedValue, (long)((Integer)ref.get()).intValue());
    }

    @Test
    public void whenTrackingRead_thenReadonlyOperationSucceeds() {
        DefaultTransactionalReference ref = new DefaultTransactionalReference((Object)10);
        long version = stm.getVersion();
        ReadonlyTransactionTest.executeTrackingReadonlyMethod((DefaultTransactionalReference<Integer>)ref, 10);
        Assert.assertEquals((long)version, (long)stm.getVersion());
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public static void executeTrackingReadonlyMethod(DefaultTransactionalReference<Integer> ref, int expectedValue) {
        int found = (Integer)ref.get();
        Assert.assertEquals((long)expectedValue, (long)found);
    }

    @Test
    public void whenNonTrackingReadonly_thenModificationInReadonlyTransactionIsDetected() {
        DefaultTransactionalReference ref = new DefaultTransactionalReference((Object)0);
        long version = stm.getVersion();
        try {
            ReadonlyTransactionTest.nonTrackingReadonlyMethodThatUpdates((DefaultTransactionalReference<Integer>)ref);
            Assert.fail();
        }
        catch (ReadonlyException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)stm.getVersion());
        Assert.assertEquals((long)0L, (long)((Integer)ref.get()).intValue());
    }

    @TransactionalMethod(readonly=true, trackReads=false)
    public static void nonTrackingReadonlyMethodThatUpdates(DefaultTransactionalReference<Integer> ref) {
        ref.set((Object)1);
    }

    @Test
    public void whenTrackingReadonly_thenModificationInReadonlyTransactionIsDetected() {
        DefaultTransactionalReference ref = new DefaultTransactionalReference((Object)0);
        long version = stm.getVersion();
        try {
            ReadonlyTransactionTest.trackingReadonlyMethodThatUpdates((DefaultTransactionalReference<Integer>)ref);
            Assert.fail();
        }
        catch (ReadonlyException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)stm.getVersion());
        Assert.assertEquals((long)0L, (long)((Integer)ref.get()).intValue());
    }

    @TransactionalMethod(readonly=true, trackReads=false)
    public static void trackingReadonlyMethodThatUpdates(DefaultTransactionalReference<Integer> ref) {
        ref.set((Object)1);
    }

    public static AlphaTranlocal getTranlocal(Object atomicObject) {
        AlphaTransaction t = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
        return t.openForRead((AlphaTransactionalObject)atomicObject);
    }
}

