/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.exceptions.OptimisticLockFailedWriteConflict;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.stms.alpha.AlphaStm;

public class RetryCountTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void testNoRetry() {
        NoRetriesMethod method = new NoRetriesMethod();
        try {
            method.execute();
            Assert.fail();
        }
        catch (TooManyRetriesException tooManyRetriesException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)method.count);
    }

    @Test
    public void testOneRetry() {
        OneRetriesMethod method = new OneRetriesMethod();
        try {
            method.execute();
            Assert.fail();
        }
        catch (TooManyRetriesException tooManyRetriesException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)method.count);
    }

    @Test
    public void testMultipleRetries() {
        TenRetriesMethod method = new TenRetriesMethod();
        try {
            method.execute();
            Assert.fail();
        }
        catch (TooManyRetriesException tooManyRetriesException) {
            // empty catch block
        }
        Assert.assertEquals((long)11L, (long)method.count);
    }

    static class TenRetriesMethod {
        int count;

        TenRetriesMethod() {
        }

        @TransactionalMethod(maxRetries=10)
        public void execute() {
            ++this.count;
            throw new OptimisticLockFailedWriteConflict();
        }
    }

    static class OneRetriesMethod {
        int count;

        OneRetriesMethod() {
        }

        @TransactionalMethod(maxRetries=1)
        public void execute() {
            ++this.count;
            throw new OptimisticLockFailedWriteConflict();
        }
    }

    static class NoRetriesMethod {
        int count;

        NoRetriesMethod() {
        }

        @TransactionalMethod(maxRetries=0)
        public void execute() {
            ++this.count;
            throw new OptimisticLockFailedWriteConflict();
        }
    }
}

