/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.WriteSkewConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.manualinstrumentation.IntStack;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class WriteSkewDetectionTest {
    private IntStack stack1;
    private IntStack stack2;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stack1 = new IntStack();
        this.stack2 = new IntStack();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenDisallowedWriteSkew_thenWriteSkewConflict() {
        TransactionFactory factory = this.stm.getTransactionFactoryBuilder().setReadTrackingEnabled(true).setSpeculativeConfigurationEnabled(false).setWriteSkewAllowed(false).build();
        AlphaTransaction t1 = (AlphaTransaction)factory.start();
        AlphaTransaction t2 = (AlphaTransaction)factory.start();
        this.stack1.push(t1, this.stack2.size(t1));
        this.stack2.push(t2, this.stack1.size(t2));
        t1.commit();
        try {
            t2.commit();
            Assert.fail();
        }
        catch (WriteSkewConflict expected) {
            // empty catch block
        }
    }

    public void assertStackContainsZero(IntStack stack) {
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertEquals((long)0L, (long)stack.pop());
    }

    @Test
    public void whenWriteSkewAllowed_thenWriteSkewHappens() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setWriteSkewAllowed(true).build();
        AlphaTransaction tx1 = (AlphaTransaction)txFactory.start();
        AlphaTransaction tx2 = (AlphaTransaction)txFactory.start();
        this.stack1.push(tx1, this.stack2.size(tx1));
        this.stack2.push(tx2, this.stack1.size(tx2));
        tx1.commit();
        tx2.commit();
        this.assertStackContainsZero(this.stack1);
        this.assertStackContainsZero(this.stack2);
    }

    @Test
    public void whenNonTrackingUpdateTransaction_thenWriteSkewNotDetected() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadTrackingEnabled(false).setReadonly(false).build();
        AlphaTransaction tx1 = (AlphaTransaction)txFactory.start();
        AlphaTransaction tx2 = (AlphaTransaction)txFactory.start();
        this.stack1.push(tx1, this.stack2.size(tx1));
        this.stack2.push(tx2, this.stack1.size(tx2));
        tx1.commit();
        tx2.commit();
        this.assertStackContainsZero(this.stack1);
        this.assertStackContainsZero(this.stack2);
    }
}

