/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.IntStackTranlocal;
import org.multiverse.stms.alpha.mixins.DefaultTxObjectMixin;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.templates.TransactionTemplate;

public final class IntStack
extends DefaultTxObjectMixin {
    private static final TransactionFactory sizeTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setReadTrackingEnabled(false).build();
    private static final TransactionFactory isEmptyTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setReadTrackingEnabled(false).build();
    public static final TransactionFactory popTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(false).setSpeculativeConfigurationEnabled(true).setWriteSkewAllowed(true).setFamilyName("IntStack.pop()").setReadTrackingEnabled(true).build();
    public static final TransactionFactory pushTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(false).setSpeculativeConfigurationEnabled(true).setWriteSkewAllowed(true).setFamilyName("IntStack.push()").setReadTrackingEnabled(false).build();

    public IntStack() {
        new TransactionTemplate(){

            public Object execute(Transaction t) {
                IntStackTranlocal tranlocal = (IntStackTranlocal)((AlphaTransaction)t).openForConstruction((AlphaTransactionalObject)IntStack.this);
                return null;
            }
        }.execute();
    }

    public int size() {
        return (Integer)new TransactionTemplate<Integer>(sizeTxFactory){

            public Integer execute(Transaction transaction) {
                return IntStack.this.size((AlphaTransaction)transaction);
            }
        }.execute();
    }

    public int size(AlphaTransaction t) {
        IntStackTranlocal tranlocal = (IntStackTranlocal)t.openForRead((AlphaTransactionalObject)this);
        return tranlocal.size;
    }

    public boolean isEmpty() {
        return (Boolean)new TransactionTemplate<Boolean>(isEmptyTxFactory){

            public Boolean execute(Transaction transaction) {
                AlphaTransaction t = (AlphaTransaction)transaction;
                IntStackTranlocal tranlocal = (IntStackTranlocal)t.openForRead((AlphaTransactionalObject)IntStack.this);
                return tranlocal.size == 0;
            }
        }.execute();
    }

    public int pop() {
        return (Integer)new TransactionTemplate<Integer>(popTxFactory){

            public Integer execute(Transaction t) {
                return IntStack.this.pop((AlphaTransaction)t);
            }
        }.execute();
    }

    public int pop(AlphaTransaction t) {
        IntStackTranlocal tranlocal = (IntStackTranlocal)t.openForWrite((AlphaTransactionalObject)this);
        if (tranlocal.head == null) {
            StmUtils.retry();
        }
        --tranlocal.size;
        IntStackTranlocal.IntNode oldHead = tranlocal.head;
        tranlocal.head = oldHead.next;
        return oldHead.value;
    }

    public void push(final int value) {
        new TransactionTemplate(pushTxFactory){

            public Integer execute(Transaction t) {
                IntStack.this.push((AlphaTransaction)t, value);
                return null;
            }
        }.execute();
    }

    public void push(AlphaTransaction t, int value) {
        IntStackTranlocal tranlocal = (IntStackTranlocal)t.openForWrite((AlphaTransactionalObject)this);
        this.push(tranlocal, value);
    }

    public void push(IntStackTranlocal tranlocal, int value) {
        if (tranlocal.isCommitted()) {
            throw new ReadonlyException();
        }
        tranlocal.head = new IntStackTranlocal.IntNode(value, tranlocal.head);
        ++tranlocal.size;
    }

    public AlphaTranlocal ___openUnconstructed() {
        return new IntStackTranlocal(this);
    }
}

