/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTestUtils;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.IntStack;
import org.multiverse.stms.alpha.manualinstrumentation.IntStackTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class IntStackTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    public AlphaTransaction startTransaction() {
        AlphaTransaction t = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void testNewStackIsDirtyByDefault() {
        AlphaTransaction t = this.startTransaction();
        IntStack intStack = new IntStack();
        IntStackTranlocal tranlocal = (IntStackTranlocal)t.openForWrite((AlphaTransactionalObject)intStack);
        Assert.assertTrue((boolean)tranlocal.isDirty());
    }

    @Test
    public void openedForWriteStackIsNotDirty() {
        IntStack intStack = new IntStack();
        AlphaTransaction t = this.startTransaction();
        IntStackTranlocal tranlocal = (IntStackTranlocal)t.openForWrite((AlphaTransactionalObject)intStack);
        Assert.assertFalse((boolean)tranlocal.isDirty());
    }

    @Test
    public void modifiedStackIsDirty() {
        IntStack intStack = new IntStack();
        AlphaTransaction t = this.startTransaction();
        intStack.push(1);
        IntStackTranlocal tranlocal = (IntStackTranlocal)t.openForWrite((AlphaTransactionalObject)intStack);
        Assert.assertTrue((boolean)tranlocal.isDirty());
    }

    @Test
    public void testEmptyStack() {
        AlphaTransaction t1 = this.startTransaction();
        IntStack intStack = new IntStack();
        Assert.assertTrue((boolean)intStack.isEmpty());
        t1.commit();
        AlphaTransaction t2 = this.startTransaction();
        Assert.assertTrue((boolean)intStack.isEmpty());
    }

    @Test
    public void testNonEmptyStack() {
        AlphaTransaction t1 = this.startTransaction();
        IntStack intStack = new IntStack();
        intStack.push(5);
        intStack.push(10);
        Assert.assertEquals((long)2L, (long)intStack.size());
        t1.commit();
        AlphaTransaction t2 = this.startTransaction();
        Assert.assertEquals((long)2L, (long)intStack.size());
        Assert.assertEquals((long)10L, (long)intStack.pop());
        Assert.assertEquals((long)5L, (long)intStack.pop());
    }

    @Test
    public void testRollback() {
        AlphaTransaction t1 = this.startTransaction();
        IntStack intStack = new IntStack();
        intStack.push(10);
        t1.commit();
        AlphaTransaction t2 = this.startTransaction();
        Assert.assertEquals((long)10L, (long)intStack.pop());
        t2.abort();
        AlphaTransaction t3 = this.startTransaction();
        Assert.assertEquals((long)1L, (long)intStack.size());
        Assert.assertEquals((long)10L, (long)intStack.pop());
    }

    @Test
    public void testPushAndPop() {
        AlphaTransaction t1 = this.startTransaction();
        IntStack intStack = new IntStack();
        t1.commit();
        AlphaTransaction t2 = this.startTransaction();
        intStack.push(1);
        t2.commit();
        AlphaTransaction t3 = this.startTransaction();
        int popped = intStack.pop();
        t3.commit();
        Assert.assertEquals((long)1L, (long)popped);
    }
}

