/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.multiverse.api.Listeners;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.mixins.DefaultTxObjectMixin;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.templates.TransactionTemplate;

public class ManualRef
extends DefaultTxObjectMixin {
    private List<Transaction> lockTransactions = new LinkedList<Transaction>();
    private List<Transaction> releaseLockTransactions = new LinkedList<Transaction>();

    public static ManualRef createUncommitted() {
        return new ManualRef(String.class);
    }

    public ManualRef(AlphaStm stm) {
        this(stm, 0);
    }

    public ManualRef(AlphaStm stm, final int value) {
        new TransactionTemplate(stm.getTransactionFactoryBuilder().build(), false, false, true){

            public Object execute(Transaction t) {
                ManualRefTranlocal tranlocal = (ManualRefTranlocal)((AlphaTransaction)t).openForConstruction((AlphaTransactionalObject)ManualRef.this);
                tranlocal.value = value;
                return null;
            }
        }.execute();
    }

    public ManualRef(AlphaTransaction tx, int value) {
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForConstruction((AlphaTransactionalObject)this);
        tranlocal.value = value;
    }

    private ManualRef(Class someClass) {
    }

    public int get(AlphaStm stm) {
        TransactionFactory txFactory = stm.getTransactionFactoryBuilder().setReadonly(true).build();
        return this.get(txFactory);
    }

    public int get(TransactionFactory txFactory) {
        return (Integer)new TransactionTemplate<Integer>(txFactory, false, false, true){

            public Integer execute(Transaction t) throws Exception {
                return ManualRef.this.get((AlphaTransaction)t);
            }
        }.execute();
    }

    public int get(AlphaTransaction t) {
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)t.openForRead((AlphaTransactionalObject)this);
        return tranlocal.value;
    }

    public void inc(AlphaStm stm) {
        TransactionFactory txFactory = stm.getTransactionFactoryBuilder().setReadonly(false).build();
        this.inc(txFactory);
    }

    public void inc(TransactionFactory txFactory) {
        new TransactionTemplate(txFactory, false, false, true){

            public Object execute(Transaction t) {
                ManualRef.this.inc((AlphaTransaction)t);
                return null;
            }
        }.execute();
    }

    public void inc(AlphaTransaction tx) {
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)this);
        ++tranlocal.value;
    }

    public void inc(AlphaTransaction tx, int value) {
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)this);
        tranlocal.value += value;
    }

    public void set(AlphaStm stm, int value) {
        TransactionFactory factory = stm.getTransactionFactoryBuilder().setReadonly(false).build();
        this.set(factory, value);
    }

    public void set(TransactionFactory txFactory, final int value) {
        new TransactionTemplate(txFactory, false, false, true){

            public Object execute(Transaction t) throws Exception {
                ManualRef.this.set((AlphaTransaction)t, value);
                return null;
            }
        }.execute();
    }

    public void set(AlphaTransaction tx, int value) {
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)this);
        tranlocal.value = value;
    }

    public ManualRefTranlocal ___openUnconstructed() {
        return new ManualRefTranlocal(this);
    }

    public Listeners ___storeUpdate(AlphaTranlocal tranlocal, long writeVersion, boolean releaseLock) {
        if (releaseLock) {
            this.releaseLockTransactions.add(this.___getLockOwner());
        }
        return super.___storeUpdate(tranlocal, writeVersion, releaseLock);
    }

    public boolean ___tryLock(Transaction lockOwner) {
        boolean success = super.___tryLock(lockOwner);
        this.lockTransactions.add(lockOwner);
        return success;
    }

    public void ___releaseLock(Transaction expectedLockOwner) {
        this.releaseLockTransactions.add(expectedLockOwner);
        super.___releaseLock(expectedLockOwner);
    }

    public void resetLockInfo() {
        this.lockTransactions.clear();
        this.releaseLockTransactions.clear();
    }

    public void assertNoLockAcquired() {
        Assert.assertTrue((boolean)this.lockTransactions.isEmpty());
    }

    public void assertLockAcquired() {
        Assert.assertFalse((boolean)this.lockTransactions.isEmpty());
    }

    public void assertNoLocksReleased() {
        Assert.assertTrue((boolean)this.releaseLockTransactions.isEmpty());
    }

    public void assertLockReleased() {
        Assert.assertFalse((boolean)this.releaseLockTransactions.isEmpty());
    }
}

