/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.programmatic.ProgrammaticLong;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class AlphaProgrammaticLong_Test {
    private AlphaStm stm;
    private TransactionFactory<AlphaTransaction> txFactory;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
    }

    @Test
    public void testBasics() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(10L);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void normalInc() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(10L);
        ref.inc(5L);
        Assert.assertEquals((long)15L, (long)ref.get());
    }

    @Test
    public void commutingInc() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(10L);
        Transaction tx = this.txFactory.start();
        ref.commutingInc(tx, 1L);
        tx.commit();
        Assert.assertEquals((long)11L, (long)ref.get());
    }

    @Test
    public void conflictingcommutingInc() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(10L);
        Transaction tx1 = this.txFactory.start();
        ref.commutingInc(tx1, 1L);
        Transaction tx2 = this.txFactory.start();
        ref.commutingInc(tx2, 1L);
        tx2.commit();
        tx1.commit();
        Assert.assertEquals((long)12L, (long)ref.get());
    }

    @Test
    public void test() {
        Foo foo = new Foo();
        foo.inc();
        Assert.assertEquals((long)1L, (long)foo.get());
    }

    @TransactionalObject
    class Foo {
        final ProgrammaticLong size = GlobalStmInstance.getGlobalStmInstance().getProgrammaticReferenceFactoryBuilder().build().createLong(0L);

        Foo() {
        }

        public void inc() {
            this.size.inc(ThreadLocalTransaction.getThreadLocalTransaction(), 1L);
        }

        public long get() {
            return this.size.get();
        }
    }
}

