/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongTranlocal;

public class AlphaProgrammaticLong_atomicCompareAndSetTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNotCommittedBefore_thenUncommittedReadConflict() {
        AlphaProgrammaticLong ref = AlphaProgrammaticLong.createUncommitted((AlphaStm)this.stm);
        long version = this.stm.getVersion();
        try {
            ref.atomicCompareAndSet(10L, 20L);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenValueMatches() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        long version = this.stm.getVersion();
        boolean result = ref.atomicCompareAndSet(1L, 5L);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)5L, (long)ref.get());
        Assert.assertNull((Object)ref.___getLockOwner());
        AlphaProgrammaticLongTranlocal current = (AlphaProgrammaticLongTranlocal)ref.___load();
        Assert.assertNotNull((Object)current);
        Assert.assertTrue((boolean)current.isCommitted());
        Assert.assertEquals((long)5L, (long)current.value);
        Assert.assertEquals((long)(version + 1L), (long)current.___writeVersion);
    }

    @Test
    public void whenLocked_thenFalse() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaProgrammaticLongTranlocal committed = (AlphaProgrammaticLongTranlocal)ref.___load();
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        boolean result = ref.atomicCompareAndSet(10L, 20L);
        Assert.assertFalse((boolean)result);
        Assert.assertSame((Object)lockOwner, (Object)ref.___getLockOwner());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)committed, (Object)ref.___load());
    }

    @Test
    public void whenNoChange() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaProgrammaticLongTranlocal committed = (AlphaProgrammaticLongTranlocal)ref.___load();
        long version = this.stm.getVersion();
        boolean success = ref.atomicCompareAndSet(10L, 10L);
        Assert.assertTrue((boolean)success);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.atomicGet());
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertSame((Object)committed, (Object)ref.___load());
    }

    @Test
    public void whenChangeThenListenersNotified() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        CheapLatch latch = new CheapLatch();
        ref.___registerRetryListener((Latch)latch, this.stm.getVersion() + 1L);
        ref.atomicCompareAndSet(10L, 20L);
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void whenValueNotMatches() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        AlphaProgrammaticLongTranlocal readonly = (AlphaProgrammaticLongTranlocal)ref.___load();
        long version = this.stm.getVersion();
        boolean result = ref.atomicCompareAndSet(2L, 5L);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)ref.get());
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertSame((Object)readonly, (Object)ref.___load());
    }
}

