/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongTranlocal;

public class AlphaProgrammaticLong_atomicGetTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        long version = this.stm.getVersion();
        long value = ref.atomicGet();
        Assert.assertEquals((long)value, (long)10L);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenNoCommitExecutedBefore() {
        AlphaProgrammaticLong ref = AlphaProgrammaticLong.createUncommitted((AlphaStm)this.stm);
        long version = this.stm.getVersion();
        long value = ref.atomicGet();
        Assert.assertEquals((long)0L, (long)value);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
    }

    @Test
    public void whenLocked_thenNoProblem() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaProgrammaticLongTranlocal committed = (AlphaProgrammaticLongTranlocal)ref.___load();
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        long value = ref.atomicGet();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)value, (long)10L);
        Assert.assertSame((Object)committed, (Object)ref.___load());
        Assert.assertSame((Object)lockOwner, (Object)ref.___getLockOwner());
    }

    @Test
    public void whenTransactionRunning_thenItsIgnored() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        ref.inc(tx, 2L);
        long version = this.stm.getVersion();
        long value = ref.atomicGet();
        Assert.assertEquals((long)10L, (long)value);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

