/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.ThreadLocalRandom;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;

public class AlphaProgrammaticLong_atomicStressTest {
    private AlphaStm stm;
    private AlphaProgrammaticLong[] refs;
    private int refCount = 1000;
    private int threadCount = 2;
    private long incCountPerThread = 200000000L;
    private ProgrammaticReferenceFactory refFactory;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.refFactory = this.stm.getProgrammaticReferenceFactoryBuilder().build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.refs = this.createRefs();
        TestThread[] threads = this.createThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        long totalIncCount = (long)this.threadCount * this.incCountPerThread;
        Assert.assertEquals((long)totalIncCount, (long)this.sum());
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)totalIncCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }

    private long sum() {
        long result = 0L;
        for (AlphaProgrammaticLong ref : this.refs) {
            result += ref.get();
        }
        return result;
    }

    private AlphaProgrammaticLong[] createRefs() {
        AlphaProgrammaticLong[] refs = new AlphaProgrammaticLong[this.refCount];
        for (int k = 0; k < this.refCount; ++k) {
            refs[k] = (AlphaProgrammaticLong)this.refFactory.atomicCreateLong(0L);
        }
        return refs;
    }

    private AtomicIncThread[] createThreads() {
        AtomicIncThread[] threads = new AtomicIncThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            threads[k] = new AtomicIncThread(k + 1);
        }
        return threads;
    }

    public class AtomicIncThread
    extends TestThread {
        private int id;

        public AtomicIncThread(int id) {
            super("AtomicIncThread-" + id);
            this.id = id;
        }

        public void doRun() throws Exception {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int k = 0;
            while ((long)k < AlphaProgrammaticLong_atomicStressTest.this.incCountPerThread) {
                int refIndex = Math.abs(Math.abs(random.nextInt()) % AlphaProgrammaticLong_atomicStressTest.this.refs.length);
                if (refIndex < 0) {
                    System.out.println("refIndex: " + refIndex);
                }
                AlphaProgrammaticLong_atomicStressTest.this.refs[refIndex].atomicInc(1L);
                if (k % 5000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }
    }
}

