/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongTranlocal;

public class AlphaProgrammaticLong_commutingIncTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNoTransactionIsRunning_andNoChange() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaProgrammaticLongTranlocal readonly = (AlphaProgrammaticLongTranlocal)ref.___load();
        long version = this.stm.getVersion();
        ref.commutingInc(0L);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)readonly, (Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenNoTransactionIsRunning_thenItIsExecutedAtomically() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        long version = this.stm.getVersion();
        ref.commutingInc(3L);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        AlphaProgrammaticLongTranlocal readonly = (AlphaProgrammaticLongTranlocal)ref.___load();
        Assert.assertNotNull((Object)readonly);
        Assert.assertEquals((long)(version + 1L), (long)readonly.getWriteVersion());
        Assert.assertEquals((long)13L, (long)ref.atomicGet());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenNoTransactionIsRunningAndNoCommits() {
        AlphaProgrammaticLong ref = AlphaProgrammaticLong.createUncommitted((AlphaStm)this.stm);
        long version = this.stm.getVersion();
        try {
            ref.commutingInc(1L);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenNoTransactionAndLocked_thenTooManyRetries() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        AlphaProgrammaticLongTranlocal committed = (AlphaProgrammaticLongTranlocal)ref.___load();
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        try {
            ref.commutingInc(10L);
            Assert.fail();
        }
        catch (TooManyRetriesException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)committed, (Object)ref.___load());
        Assert.assertSame((Object)lockOwner, (Object)ref.___getLockOwner());
    }

    @Test
    public void whenTransactionRunning() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        long version = this.stm.getVersion();
        ref.commutingInc(10L);
        tx.commit();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)ref.atomicGet());
    }
}

