/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticLong;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;

public class AlphaProgrammaticLong_incReadConsistencyStressTest {
    private int refCount = 10;
    private volatile boolean completed;
    private ProgrammaticLong[] refs;
    private Stm stm;
    private int transactionCount = 1000000;
    private int readerCount = 10;

    @Before
    public void setUp() {
        this.completed = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ProgrammaticReferenceFactory refFactory = this.stm.getProgrammaticReferenceFactoryBuilder().build();
        this.refs = new ProgrammaticLong[this.refCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = refFactory.atomicCreateLong(0L);
        }
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testWithCommute() {
        this.test(true);
    }

    @Test
    public void testWithoutCommit() {
        this.test(false);
    }

    public void test(boolean commute) {
        CommutingIncThread incThread = new CommutingIncThread(commute);
        TestThread[] readThreads = new ReadThread[this.readerCount];
        for (int k = 0; k < readThreads.length; ++k) {
            readThreads[k] = new ReadThread(1);
        }
        TestUtils.startAll((TestThread[])new TestThread[]{incThread});
        TestUtils.startAll((TestThread[])readThreads);
        TestUtils.joinAll((TestThread[])readThreads);
        TestUtils.joinAll((TestThread[])new TestThread[]{incThread});
    }

    public class CommutingIncThread
    extends TestThread {
        private final boolean commute;

        public CommutingIncThread(boolean commute) {
            super("IncThread");
            this.commute = commute;
        }

        public void doRun() throws Exception {
            int k = 0;
            while (!AlphaProgrammaticLong_incReadConsistencyStressTest.this.completed) {
                TestUtils.sleepRandomUs((int)10);
                if (k % 100000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }

        public void inc() {
            for (int k = 0; k < AlphaProgrammaticLong_incReadConsistencyStressTest.this.refs.length; ++k) {
                if (!TestUtils.randomOneOf((int)5)) continue;
                if (this.commute) {
                    AlphaProgrammaticLong_incReadConsistencyStressTest.this.refs[k].commutingInc(1L);
                    continue;
                }
                AlphaProgrammaticLong_incReadConsistencyStressTest.this.refs[k].atomicInc(1L);
            }
        }
    }

    public class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticLong_incReadConsistencyStressTest.this.transactionCount; ++k) {
                this.read();
                TestUtils.sleepRandomUs((int)10);
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
            AlphaProgrammaticLong_incReadConsistencyStressTest.this.completed = true;
        }

        @TransactionalMethod(readonly=true, trackReads=false)
        private void read() {
            int sumT1 = 0;
            for (ProgrammaticLong ref : AlphaProgrammaticLong_incReadConsistencyStressTest.this.refs) {
                sumT1 = (int)((long)sumT1 + ref.get());
            }
            TestUtils.sleepRandomUs((int)10);
            int sumT2 = 0;
            for (ProgrammaticLong ref : AlphaProgrammaticLong_incReadConsistencyStressTest.this.refs) {
                sumT2 = (int)((long)sumT2 + ref.get());
            }
            Assert.assertEquals((long)sumT1, (long)sumT2);
        }
    }
}

