/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongTranlocal;

public class AlphaProgrammaticLong_setTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void after() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNoTransactionAvailable_thenCallExecutedAtomically() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        long version = this.stm.getVersion();
        ref.set(20L);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)20L, (long)ref.atomicGet());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenNoChange() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaProgrammaticLongTranlocal tranlocal = (AlphaProgrammaticLongTranlocal)ref.___load();
        long version = this.stm.getVersion();
        long found = ref.set(10L);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)found);
        Assert.assertSame((Object)tranlocal, (Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenNotCommittedBefore_thenUncommittedReadConflict() {
        AlphaProgrammaticLong ref = AlphaProgrammaticLong.createUncommitted((AlphaStm)this.stm);
        long version = this.stm.getVersion();
        try {
            ref.set(10L);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenListenersExists_thenTheyAreNotified() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        CheapLatch latch = new CheapLatch();
        ref.___registerRetryListener((Latch)latch, this.stm.getVersion() + 1L);
        ref.set(20L);
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void whenTransactionAvailable_thenItLiftsOnThatTransaction() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaProgrammaticLongTranlocal committed = (AlphaProgrammaticLongTranlocal)ref.___load();
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadTrackingEnabled(true).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        long version = this.stm.getVersion();
        long found = ref.set(20L);
        tx.abort();
        Assert.assertEquals((long)10L, (long)found);
        Assert.assertEquals((long)10L, (long)ref.atomicGet());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)committed, (Object)ref.___load());
        Assert.assertNull((Object)ref.___getListeners());
    }
}

