/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class AlphaProgrammaticLong_setWithTransactionTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenTransactionNull_thenNullPointerException() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        long version = this.stm.getVersion();
        try {
            ref.set(null, 20L);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)ref.atomicGet());
    }

    @Test
    public void whenSuccess() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        long version = this.stm.getVersion();
        ref.set((Transaction)tx, 20L);
        Assert.assertEquals((long)10L, (long)ref.atomicGet());
        tx.commit();
        Assert.assertEquals((long)20L, (long)ref.atomicGet());
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
    }

    @Test
    public void whenNoChange() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaProgrammaticLongTranlocal committed = (AlphaProgrammaticLongTranlocal)ref.___load();
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        long version = this.stm.getVersion();
        ref.set((Transaction)tx, 10L);
        Assert.assertEquals((long)10L, (long)ref.atomicGet());
        tx.commit();
        Assert.assertEquals((long)10L, (long)ref.atomicGet());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)committed, (Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenNotCommittedBefore() {
        AlphaProgrammaticLong ref = AlphaProgrammaticLong.createUncommitted((AlphaStm)this.stm);
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        long version = this.stm.getVersion();
        try {
            ref.set((Transaction)tx, 10L);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().build().start();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            ref.set((Transaction)tx, 1L);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().build().start();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            ref.set((Transaction)tx, 1L);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().build().start();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            ref.set((Transaction)tx, 1L);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.get());
    }
}

