/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;

public class AlphaProgrammaticLong_sharedAtomicLongStressTest {
    private final AtomicLong ref = new AtomicLong();
    private int threadCount = 4;
    private long incCountPerThread = 200000000L;
    private boolean strict = false;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] threads = this.createThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        long totalIncCount = (long)this.threadCount * this.incCountPerThread;
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)totalIncCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }

    private long sum(AtomicIncThread[] threads) {
        long result = 0L;
        for (AtomicIncThread thread : threads) {
            result += thread.get();
        }
        return result;
    }

    private AtomicIncThread[] createThreads() {
        AtomicIncThread[] threads = new AtomicIncThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            threads[k] = new AtomicIncThread(k);
        }
        return threads;
    }

    public class AtomicIncThread
    extends TestThread {
        public AtomicIncThread(int id) {
            super("AtomicIncThread-" + id);
        }

        public long get() {
            return AlphaProgrammaticLong_sharedAtomicLongStressTest.this.ref.get();
        }

        public void doRun() throws Exception {
            int k = 0;
            while ((long)k < AlphaProgrammaticLong_sharedAtomicLongStressTest.this.incCountPerThread) {
                if (AlphaProgrammaticLong_sharedAtomicLongStressTest.this.strict) {
                    AlphaProgrammaticLong_sharedAtomicLongStressTest.this.ref.incrementAndGet();
                } else {
                    long get = AlphaProgrammaticLong_sharedAtomicLongStressTest.this.ref.get();
                    AlphaProgrammaticLong_sharedAtomicLongStressTest.this.ref.compareAndSet(get, get + 1L);
                }
                if (k % 10000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }
    }
}

