/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;

public class AlphaProgrammaticLong_unsharedAtomicLongsStressTest {
    private final boolean createObject = false;
    private int threadCount = 2;
    private long incCountPerThread = 1000000000L;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] threads = this.createThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        long totalIncCount = (long)this.threadCount * this.incCountPerThread;
        Assert.assertEquals((long)totalIncCount, (long)this.sum((AtomicIncThread[])threads));
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)totalIncCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }

    private long sum(AtomicIncThread[] threads) {
        long result = 0L;
        for (AtomicIncThread thread : threads) {
            result += thread.get();
        }
        return result;
    }

    private AtomicIncThread[] createThreads() {
        AtomicIncThread[] threads = new AtomicIncThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            threads[k] = new AtomicIncThread(k);
        }
        return threads;
    }

    static class Person {
        Person() {
        }
    }

    public class AtomicIncThread
    extends TestThread {
        private final AtomicLong ref;
        private Person p;

        public AtomicIncThread(int id) {
            super("AtomicIncThread-" + id);
            this.ref = new AtomicLong();
        }

        public long get() {
            return this.ref.get();
        }

        public void doRun() throws Exception {
            int k = 0;
            while ((long)k < AlphaProgrammaticLong_unsharedAtomicLongsStressTest.this.incCountPerThread) {
                this.ref.incrementAndGet();
                if (k % 10000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }
    }
}

