/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticReference;

public class AlphaProgrammaticReference_atomicGetPerformanceTest {
    private long transactionCount = 2000000000L;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void getAtomic() {
        AlphaProgrammaticReference ref = new AlphaProgrammaticReference();
        long startNs = System.nanoTime();
        for (long k = 0L; k < this.transactionCount; ++k) {
            ref.atomicGet();
            if (k % 100000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)this.transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }

    @Test
    public void get() {
        AlphaProgrammaticReference ref = new AlphaProgrammaticReference();
        long startNs = System.nanoTime();
        for (long k = 0L; k < this.transactionCount; ++k) {
            ref.get();
            if (k % 100000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)this.transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }
}

