/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticReference;

public class AlphaProgrammaticReference_blockingStressTest {
    private AlphaStm stm;
    private ProgrammaticReferenceFactory refFactory;
    private AlphaProgrammaticReference ref;
    private int consumerCount = 10;
    private int transactionCount = 2000000;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.refFactory = this.stm.getProgrammaticReferenceFactoryBuilder().build();
        this.ref = (AlphaProgrammaticReference)this.refFactory.atomicCreateReference((Object)0);
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            producers[k] = new ProducerThread(k);
        }
        TestThread[] consumers = new ConsumerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
    }

    class ConsumerThread
    extends TestThread {
        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticReference_blockingStressTest.this.transactionCount; ++k) {
                this.consume();
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod(readonly=false)
        private void consume() {
            if (AlphaProgrammaticReference_blockingStressTest.this.ref.get() == null) {
                StmUtils.retry();
            }
            AlphaProgrammaticReference_blockingStressTest.this.ref.set(null);
        }
    }

    class ProducerThread
    extends TestThread {
        public ProducerThread(int id) {
            super("ProducerThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticReference_blockingStressTest.this.transactionCount; ++k) {
                this.produce();
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod(readonly=false)
        private void produce() {
            if (AlphaProgrammaticReference_blockingStressTest.this.ref.get() != null) {
                StmUtils.retry();
            }
            AlphaProgrammaticReference_blockingStressTest.this.ref.set((Object)"foo");
        }
    }
}

