/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticReference;

public class AlphaProgrammaticReference_isNullPerformanceTest {
    private long transactionCount = 100000000L;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void isNullAtomic() {
        AlphaProgrammaticReference ref = new AlphaProgrammaticReference();
        long startNs = System.nanoTime();
        for (long k = 0L; k < this.transactionCount; ++k) {
            ref.atomicIsNull();
            if (k % 100000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)this.transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }

    @Test
    public void isNull() {
        AlphaProgrammaticReference ref = new AlphaProgrammaticReference();
        long startNs = System.nanoTime();
        for (long k = 0L; k < this.transactionCount; ++k) {
            ref.isNull();
            if (k % 100000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)this.transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }
}

