/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.readonly.ArrayReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class ArrayReadonlyAlphaTransaction_registerRetryLatchTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public ArrayReadonlyAlphaTransaction startTransactionUnderTest(int size) {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new ArrayReadonlyAlphaTransaction(config, size);
    }

    @Test
    public void whenExplicitRetryNotAllowed_thenNoRetryPossibleException() {
        ManualRef ref = new ManualRef(this.stm);
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true).withExplicitRetryAllowed(false);
        ArrayReadonlyAlphaTransaction tx = new ArrayReadonlyAlphaTransaction(config, 100);
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenNoReads_thenNoRetryPossibleException() {
        ArrayReadonlyAlphaTransaction tx = this.startTransactionUnderTest(10);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException noRetryPossibleException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenFirstListener_listenerAdded() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        ArrayReadonlyAlphaTransaction tx = this.startTransactionUnderTest(10);
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.registerRetryLatch((Latch)latch);
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch});
    }

    @Test
    public void whenMultipleListenersAvailable_thenLatchIsRegisteredTooAll() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRef ref3 = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        ArrayReadonlyAlphaTransaction tx = this.startTransactionUnderTest(10);
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        tx.openForRead((AlphaTransactionalObject)ref3);
        tx.registerRetryLatch((Latch)latch);
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref1, new Latch[]{latch});
        AlphaTransactionTestUtils.assertHasListeners(ref2, new Latch[]{latch});
        AlphaTransactionTestUtils.assertHasListeners(ref3, new Latch[]{latch});
    }

    @Test
    public void whenCorrectVersionFound_thenRegistrationAbortedAndLatchOpened() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRef ref3 = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        ArrayReadonlyAlphaTransaction tx = this.startTransactionUnderTest(10);
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        tx.openForRead((AlphaTransactionalObject)ref3);
        ref2.inc(this.stm);
        tx.registerRetryLatch((Latch)latch);
        Assert.assertTrue((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref1, new Latch[]{latch});
        AlphaTransactionTestUtils.assertHasNoListeners(ref2);
        AlphaTransactionTestUtils.assertHasNoListeners(ref3);
    }

    @Test
    public void whenPreexistingListener_thenListenerAppended() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch1 = new CheapLatch();
        CheapLatch latch2 = new CheapLatch();
        ArrayReadonlyAlphaTransaction tx1 = this.startTransactionUnderTest(10);
        tx1.openForRead((AlphaTransactionalObject)ref);
        tx1.registerRetryLatch((Latch)latch1);
        ArrayReadonlyAlphaTransaction tx2 = this.startTransactionUnderTest(10);
        tx2.openForRead((AlphaTransactionalObject)ref);
        tx2.registerRetryLatch((Latch)latch2);
        Assert.assertFalse((boolean)latch1.isOpen());
        Assert.assertFalse((boolean)latch2.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch2, latch1});
    }
}

