/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.MapReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MapReadonlyAlphaTransaction_openForConstructionTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapReadonlyAlphaTransaction startTransactionUnderTest() {
        return this.startTransactionUnderTest(new SpeculativeConfiguration(100));
    }

    public MapReadonlyAlphaTransaction startTransactionUnderTest(SpeculativeConfiguration speculativeConfig) {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true).withSpeculativeConfig(speculativeConfig);
        return new MapReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenActiveAndNullTxObject_thenNullPointerException() {
        MapReadonlyAlphaTransaction tx = this.startTransactionUnderTest();
        try {
            tx.openForConstruction(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void withExplicitReadlonly_thenReadonlyException() {
        ManualRef ref = new ManualRef(this.stm, 0);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, true, true, 100);
        MapReadonlyAlphaTransaction tx = this.startTransactionUnderTest(speculativeConfig);
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (ReadonlyException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void withSpeculativeReadlonly_thenSpeculativeConfigurationFailure() {
        ManualRef ref = new ManualRef(this.stm, 0);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(true, false, false, 100);
        MapReadonlyAlphaTransaction tx = this.startTransactionUnderTest(speculativeConfig);
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertFalse((boolean)speculativeConfig.isReadonly());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef value = new ManualRef(this.stm, 10);
        MapReadonlyAlphaTransaction tx = this.startTransactionUnderTest();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef value = new ManualRef(this.stm, 10);
        MapReadonlyAlphaTransaction tx = this.startTransactionUnderTest();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef value = new ManualRef(this.stm, 10);
        MapReadonlyAlphaTransaction tx = this.startTransactionUnderTest();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            tx.openForConstruction((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

