/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.MonoReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MonoReadonlyAlphaTransaction_openForReadTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createFastConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoReadonlyAlphaTransaction startSutTransaction() {
        return this.startSutTransaction(new SpeculativeConfiguration(true, true, true, 100));
    }

    public MonoReadonlyAlphaTransaction startSutTransaction(SpeculativeConfiguration speculativeConfig) {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true).withSpeculativeConfig(speculativeConfig).withMaxRetries(10);
        return new MonoReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertSame((Object)((Object)committed), (Object)((Object)found));
        Assert.assertSame((Object)((Object)committed), (Object)TestUtils.getField((Object)tx, (String)"attached"));
    }

    @Test
    public void whenNotCommittedBefore_thenUncommittedReadConflict() {
        ManualRef ref = ManualRef.createUncommitted();
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (UncommittedReadConflict uncommittedReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenLockedButExactVersionMatch_thenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal readonly = ref.___load();
        AlphaTransaction owner = (AlphaTransaction)Mockito.mock(AlphaTransaction.class);
        ref.___tryLock((Transaction)owner);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal tranlocal = tx.openForRead((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)readonly, (Object)tranlocal);
    }

    @Test
    public void whenLockedAndVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenLockedAndVersionTooOld_thenLockNotFreeReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        this.stm.getClock().tick();
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenAlreadyAttached_thenSameTranlocalReturned() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal found1 = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        ManualRefTranlocal found2 = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)found2.isCommitted());
        Assert.assertFalse((boolean)found2.isCommuting());
        Assert.assertSame((Object)((Object)found1), (Object)((Object)found2));
    }

    @Test
    public void whenReadConflict_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        ref.inc(this.stm);
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)TestUtils.getField((Object)tx, (String)"attached"));
    }

    @Test
    public void whenLoaded_thenNotSubjectToReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal tranlocal1 = tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        AlphaTranlocal tranlocal2 = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)tranlocal1, (Object)tranlocal2);
    }

    @Test
    public void whenMaximumCapacityIsReached_thenTransactionTooSmallException() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(true, true, true, 100);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction(speculativeConfig);
        tx.openForRead((AlphaTransactionalObject)ref1);
        try {
            tx.openForRead((AlphaTransactionalObject)ref2);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)2L, (long)speculativeConfig.getOptimalSize());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

