/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class NonTrackingReadonlyAlphaTransaction_openForWriteTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public NonTrackingReadonlyAlphaTransaction startSutTransaction() {
        return this.startSutTransaction(new SpeculativeConfiguration(100));
    }

    public NonTrackingReadonlyAlphaTransaction startSutTransaction(SpeculativeConfiguration speculativeConfig) {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, false).withSpeculativeConfig(speculativeConfig);
        return new NonTrackingReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenActiveAndNullTxObject_thenNullPointerException() {
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        try {
            tx.openForWrite(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void withExplicitReadonly_thenReadonlyException() {
        ManualRef ref = new ManualRef(this.stm, 0);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, true, true, 100);
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction(speculativeConfig);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (ReadonlyException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)speculativeConfig.isReadonly());
    }

    @Test
    public void whenSpeculativeReadonly_thenSpeculativeConfigurationFailure() {
        ManualRef value = new ManualRef(this.stm, 10);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(100);
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction(speculativeConfig);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)speculativeConfig.isReadonly());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef value = new ManualRef(this.stm, 10);
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef value = new ManualRef(this.stm, 10);
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef value = new ManualRef(this.stm, 10);
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

