/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class AbstractTrackingUpdateAlphaTransaction_performanceComparison {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;
    private SpeculativeConfiguration speculativeConfig;
    private UpdateConfiguration config;
    private ManualRef[] refs;
    private int txCount = 1000;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
        this.speculativeConfig = new SpeculativeConfiguration(100);
        this.config = new UpdateConfiguration(this.stmConfig.clock).withSpeculativeConfiguration(this.speculativeConfig);
    }

    public AlphaTransaction startFixedTransaction(int size) {
        return new ArrayUpdateAlphaTransaction(this.config, size);
    }

    public AlphaTransaction startGrowingTransaction() {
        return new MapUpdateAlphaTransaction(this.config);
    }

    @Test
    public void test_1() {
        this.test(1);
    }

    @Test
    public void test_2() {
        this.test(2);
        this.testWithReuse(2);
    }

    @Test
    public void test_3() {
        this.test(3);
    }

    @Test
    public void test_4() {
        this.test(4);
    }

    @Test
    public void test_5() {
        this.test(5);
    }

    @Test
    public void test_6() {
        this.test(6);
    }

    @Test
    public void test_7() {
        this.test(7);
    }

    @Test
    public void test_8() {
        this.test(8);
    }

    @Test
    public void test_9() {
        this.test(9);
    }

    @Test
    public void test_10() {
        this.test(10);
    }

    @Test
    public void test_12() {
        this.test(12);
    }

    @Test
    public void test_14() {
        this.test(14);
    }

    @Test
    public void test_17() {
        this.test(17);
    }

    @Test
    public void test_20() {
        this.test(20);
    }

    @Test
    public void test_25() {
        this.test(25);
    }

    @Test
    public void test_30() {
        this.test(30);
    }

    @Test
    public void test_40() {
        this.test(40);
    }

    @Test
    public void test_50() {
        this.test(50);
    }

    @Test
    public void test_75() {
        this.test(75);
    }

    @Test
    public void test_100() {
        this.test(100);
    }

    public void test(int transactionSize) {
        this.refs = new ManualRef[transactionSize];
        for (int k = 0; k < transactionSize; ++k) {
            this.refs[k] = new ManualRef(this.stm);
        }
        this.speculativeConfig.setOptimalSize(transactionSize);
        long startFixedNs = System.nanoTime();
        for (int k = 0; k < this.txCount; ++k) {
            AlphaTransaction tx = this.startFixedTransaction(transactionSize);
            for (int l = 0; l < transactionSize; ++l) {
                this.refs[l].inc(tx);
            }
            tx.commit();
        }
        long periodFixedNs = System.nanoTime() - startFixedNs;
        double fixedTransactionPerSecond = (long)this.txCount * TimeUnit.SECONDS.toNanos(1L) / periodFixedNs;
        long startGrowingNs = System.nanoTime();
        for (int k = 0; k < this.txCount; ++k) {
            AlphaTransaction tx = this.startGrowingTransaction();
            for (int l = 0; l < transactionSize; ++l) {
                this.refs[l].inc(tx);
            }
            tx.commit();
        }
        long periodGrowingNs = System.nanoTime() - startGrowingNs;
        double growingTransactionPerSecond = (long)this.txCount * TimeUnit.SECONDS.toNanos(1L) / periodGrowingNs;
        System.out.println("transactionsize: " + transactionSize);
        System.out.printf("growing %s tx/sec\n", growingTransactionPerSecond);
        System.out.printf("fixed %s tx/sec\n", fixedTransactionPerSecond);
        System.out.printf("fixed is %s faster than growing\n", fixedTransactionPerSecond / growingTransactionPerSecond);
    }

    public void testWithReuse(int transactionSize) {
        this.refs = new ManualRef[transactionSize];
        for (int k = 0; k < transactionSize; ++k) {
            this.refs[k] = new ManualRef(this.stm);
        }
        this.speculativeConfig.setOptimalSize(transactionSize);
        long startFixedNs = System.nanoTime();
        AlphaTransaction tx = this.startFixedTransaction(transactionSize);
        for (int k = 0; k < this.txCount; ++k) {
            for (int l = 0; l < transactionSize; ++l) {
                this.refs[l].inc(tx);
            }
            tx.commit();
            tx.restart();
        }
        long periodFixedNs = System.nanoTime() - startFixedNs;
        double fixedTransactionPerSecond = (long)this.txCount * TimeUnit.SECONDS.toNanos(1L) / periodFixedNs;
        long startGrowingNs = System.nanoTime();
        tx = this.startGrowingTransaction();
        for (int k = 0; k < this.txCount; ++k) {
            for (int l = 0; l < transactionSize; ++l) {
                this.refs[l].inc(tx);
            }
            tx.commit();
            tx.restart();
        }
        long periodGrowingNs = System.nanoTime() - startGrowingNs;
        double growingTransactionPerSecond = (long)this.txCount * TimeUnit.SECONDS.toNanos(1L) / periodGrowingNs;
        System.out.println("transactionsize: " + transactionSize);
        System.out.printf("growing %s tx/sec\n", growingTransactionPerSecond);
        System.out.printf("fixed %s tx/sec\n", fixedTransactionPerSecond);
        System.out.printf("fixed is %s faster than growing\n", fixedTransactionPerSecond / growingTransactionPerSecond);
    }
}

