/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class ArrayUpdateAlphaTransaction_openForWriteTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public AlphaTransaction startSutTransaction(int size) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    public AlphaTransaction startSutTransaction(int size, int maximumSize) {
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(maximumSize);
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withSpeculativeConfiguration(speculativeConfig);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    @Test
    public void whenOpeningUncommittedObject_thenUncommittedReadConflict() {
        ManualRef txObject = ManualRef.createUncommitted();
        AlphaTransaction tx = this.startSutTransaction(2);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)txObject);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertNull((Object)txObject.___load());
        Assert.assertNull((Object)txObject.___getLockOwner());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenFull() {
        ManualRef txObject1 = new ManualRef(this.stm, 1);
        ManualRef txObject2 = new ManualRef(this.stm, 1);
        AlphaTransaction tx = this.startSutTransaction(1, 1);
        tx.openForWrite((AlphaTransactionalObject)txObject1);
        try {
            tx.openForWrite((AlphaTransactionalObject)txObject2);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenUpdate() {
        ManualRef txObject = new ManualRef(this.stm, 10);
        ManualRefTranlocal original = (ManualRefTranlocal)txObject.___load();
        AlphaTransaction tx = this.startSutTransaction(1);
        long version = this.stm.getVersion();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)txObject);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNotNull((Object)((Object)tranlocal));
        Assert.assertTrue((boolean)tranlocal.isUncommitted());
        Assert.assertSame((Object)((Object)txObject), (Object)tranlocal.getTransactionalObject());
        Assert.assertSame((Object)((Object)original), (Object)tranlocal.getOrigin());
        Assert.assertEquals((long)10L, (long)tranlocal.value);
    }

    @Test
    public void whenNullTxObject_thenNullPointerException() {
        AlphaTransaction tx = this.startSutTransaction(1);
        try {
            tx.openForWrite(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenNotLoadedBefore_updatableVersionReturned() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        AlphaTransaction tx = this.startSutTransaction(10);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        AlphaTransactionTestUtils.assertIsUpdatableClone(ref, committed, found);
    }

    @Test
    public void whenAlreadyOpenedForRead_updatableVersionReturned() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        AlphaTransaction tx = this.startSutTransaction(10);
        tx.openForRead((AlphaTransactionalObject)ref);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertEquals((Object)1, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        AlphaTransactionTestUtils.assertIsUpdatableClone(ref, committed, found);
    }

    @Test
    public void whenAlreadyOpenedForWrite_sameVersionReturned() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(10);
        ManualRefTranlocal expected = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)expected), (Object)((Object)found));
        Assert.assertEquals((Object)1, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAlreadyOpenedForCommutingWrite_thenFixated() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 0L);
        AlphaTransaction tx = this.startSutTransaction(10);
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedButVersionMatches() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 0L);
        AlphaTransaction tx = this.startSutTransaction(10);
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        AlphaTranlocal found = tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedAndVersionTooOld_thenOldVersionNotFoundReadConflict() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 0L);
        AlphaTransaction tx = this.startSutTransaction(10);
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        ref.atomicInc(10L);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)this.stm.getVersion(), (long)version);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)openedForCommutingWrite.isCommuting());
    }

    @Test
    public void whenMaximumCapacityExceeded_thenTransactionTooSmallError() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRef ref3 = new ManualRef(this.stm);
        ManualRef ref4 = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(3, 3);
        tx.openForWrite((AlphaTransactionalObject)ref1);
        tx.openForWrite((AlphaTransactionalObject)ref2);
        tx.openForWrite((AlphaTransactionalObject)ref3);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref4);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenLockedButExactVersionMatch_thenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal readonly = ref.___load();
        AlphaTransaction owner = (AlphaTransaction)Mockito.mock(AlphaTransaction.class);
        ref.___tryLock((Transaction)owner);
        AlphaTransaction tx = this.startSutTransaction(100);
        AlphaTranlocal tranlocal = tx.openForWrite((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)readonly, (Object)tranlocal.getOrigin());
        Assert.assertFalse((boolean)tranlocal.isCommitted());
    }

    @Test
    public void whenLockedAndVersionTooOld_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        AlphaTransaction tx = this.startSutTransaction(100);
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenReadConflict_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(10);
        ref.inc(this.stm);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAlreadyOpenedForRead_thenNotSubjectToReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(10);
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void whenAlreadyOpenedForWrite_thenNotSubjectToReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(10);
        tx.openForWrite((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(1);
        tx.abort();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(1);
        tx.commit();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(1);
        tx.prepare();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException preparedTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
    }
}

