/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MonoUpdateAlphaTransaction_openForCommutingWriteTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoUpdateAlphaTransaction startSutTransaction(SpeculativeConfiguration speculativeConfig) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withSpeculativeConfiguration(speculativeConfig);
        return new MonoUpdateAlphaTransaction(config);
    }

    public MonoUpdateAlphaTransaction startSutTransaction() {
        return this.startSutTransaction(new SpeculativeConfiguration(100));
    }

    @Test
    public void whenFirstTime() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)found, (Object)TestUtils.getField((Object)tx, (String)"attached"));
        Assert.assertFalse((boolean)found.isCommitted());
        Assert.assertTrue((boolean)found.isCommuting());
        Assert.assertEquals((long)-2L, (long)found.getWriteVersion());
    }

    @Test
    public void whenLocked() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        AbstractTransactionImpl lockOwner = new AbstractTransactionImpl();
        ref.___tryLock((Transaction)lockOwner);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)found, (Object)TestUtils.getField((Object)tx, (String)"attached"));
        Assert.assertNull((Object)found.getOrigin());
        Assert.assertFalse((boolean)found.isCommitted());
        Assert.assertTrue((boolean)found.isCommuting());
        Assert.assertEquals((long)-2L, (long)found.getWriteVersion());
        Assert.assertSame((Object)lockOwner, (Object)ref.___getLockOwner());
    }

    @Test
    public void whenTransactionalObjectAlreadyOpenedForWrite() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal openedForWrite = tx.openForWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)found, (Object)TestUtils.getField((Object)tx, (String)"attached"));
        Assert.assertSame((Object)openedForWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertEquals((long)0L, (long)found.getWriteVersion());
    }

    @Test
    public void whenTransactionalObjectAlreadyOpenedForRead() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal openedForRead = tx.openForRead((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)found, (Object)TestUtils.getField((Object)tx, (String)"attached"));
        Assert.assertNotNull((Object)found);
        Assert.assertFalse((openedForRead == found ? 1 : 0) != 0);
        Assert.assertSame((Object)openedForRead, (Object)found.getOrigin());
        Assert.assertFalse((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertEquals((long)0L, (long)found.getWriteVersion());
    }

    @Test
    public void whenTransactionalObjectAlreadyOpenedForCommutingWrite() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal firstOpen = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)found, (Object)TestUtils.getField((Object)tx, (String)"attached"));
        Assert.assertSame((Object)found, (Object)firstOpen);
        Assert.assertFalse((boolean)found.isCommitted());
        Assert.assertTrue((boolean)found.isCommuting());
        Assert.assertEquals((long)-2L, (long)found.getWriteVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.prepare();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException preparedTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
    }
}

