/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MonoUpdateAlphaTransaction_openForWriteTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoUpdateAlphaTransaction startSutTransaction(SpeculativeConfiguration speculativeConfig) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withSpeculativeConfiguration(speculativeConfig);
        return new MonoUpdateAlphaTransaction(config);
    }

    public MonoUpdateAlphaTransaction startSutTransaction() {
        return this.startSutTransaction(new SpeculativeConfiguration(100));
    }

    @Test
    public void whenNullTxObject_thenNullPointerException() {
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        try {
            tx.openForWrite(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenOpenForWriteFirstTime_thenAttached() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal committed = ref.___load();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal found = tx.openForWrite((AlphaTransactionalObject)ref);
        AlphaTransactionTestUtils.assertIsUpdatableClone(ref, committed, found);
        Assert.assertSame((Object)found, (Object)TestUtils.getField((Object)tx, (String)"attached"));
    }

    @Test
    public void whenOpenForWriteOnFreshObject_thenUncommittedReadConflict() {
        ManualRef ref = ManualRef.createUncommitted();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)TestUtils.getField((Object)tx, (String)"attached"));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ref.inc(this.stm);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)TestUtils.getField((Object)tx, (String)"attached"));
    }

    @Test
    public void whenLockedAndVersionTooOld_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenReadConflict_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ref.inc(this.stm);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenOpenForWriteSecondTime_thenPreviousTranlocalReturned() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal found1 = tx.openForWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found2 = tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)found1, (Object)found2);
    }

    @Test
    public void whenAlreadyOpenedForRead_thenUpgradedToOpenedForWrite() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal committed = ref.___load();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForWrite((AlphaTransactionalObject)ref);
        AlphaTransactionTestUtils.assertIsUpdatableClone(ref, committed, found);
        Assert.assertSame((Object)found, (Object)TestUtils.getField((Object)tx, (String)"attached"));
    }

    @Test
    public void whenAlreadyOpenedForCommutingWrite() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 0L);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal openedForCommuting = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForWrite((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)openedForCommuting, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedButVersionMatches() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 0L);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        AlphaTranlocal found = tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedAndVersionTooOld_thenOldVersionNotFoundReadConflict() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 0L);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        ref.atomicInc(10L);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)this.stm.getVersion(), (long)version);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)openedForCommutingWrite.isCommuting());
    }

    @Test
    public void whenAlreadyAnotherOpenForRead_thenSpeculativeConfigurationFailure() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(100);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction(speculativeConfig);
        tx.openForRead((AlphaTransactionalObject)ref1);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref2);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)2L, (long)speculativeConfig.getOptimalSize());
    }

    @Test
    public void whenAlreadyAnotherOpenForWrite_thenSpeculativeConfigurationFailure() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(100);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction(speculativeConfig);
        tx.openForWrite((AlphaTransactionalObject)ref1);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref2);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)2L, (long)speculativeConfig.getOptimalSize());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.prepare();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException preparedTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
    }
}

