/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.templates.OrElseTemplate;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class OrElseTemplateTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    public Transaction startUpdateTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setReadTrackingEnabled(true).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void changesInLeftBranchAreNotUnsetWhenTheRightBranchIsEntered() {
        final TransactionalInteger leftRef = new TransactionalInteger();
        Transaction tx = this.startUpdateTransaction();
        new OrElseTemplate(tx){

            public Object run(Transaction tx) {
                leftRef.set(1);
                StmUtils.retry();
                return null;
            }

            public Object orelserun(Transaction tx) {
                Assert.assertEquals((long)1L, (long)leftRef.get());
                return null;
            }
        }.execute();
        Assert.assertEquals((long)1L, (long)leftRef.get());
    }

    @Test
    public void testWaitOnLeftBranch() {
        TransactionalInteger orRef = new TransactionalInteger();
        TransactionalInteger elseRef = new TransactionalInteger();
        WThread thread = new WThread(orRef, elseRef);
        thread.start();
        TestUtils.sleepMs((long)300L);
        TestUtils.assertAlive((Thread[])new Thread[]{thread});
        orRef.inc();
        TestUtils.joinAll((TestThread[])new TestThread[]{thread});
        Assert.assertEquals((Object)"run", (Object)thread.result);
    }

    @Test
    public void testWaitOnRightBranch() {
        TransactionalInteger orRef = new TransactionalInteger();
        TransactionalInteger elseRef = new TransactionalInteger();
        WThread thread = new WThread(orRef, elseRef);
        thread.start();
        TestUtils.sleepMs((long)300L);
        TestUtils.assertAlive((Thread[])new Thread[]{thread});
        elseRef.inc();
        TestUtils.joinAll((TestThread[])new TestThread[]{thread});
        Assert.assertEquals((Object)"orelserun", (Object)thread.result);
    }

    @Test
    public void testThreadLocalTx() {
        final Transaction startedTx = this.startUpdateTransaction();
        new OrElseTemplate(){

            public Object run(Transaction tx) {
                Assert.assertSame((Object)startedTx, (Object)tx);
                StmUtils.retry();
                return null;
            }

            public Object orelserun(Transaction tx) {
                Assert.assertSame((Object)startedTx, (Object)tx);
                return null;
            }
        }.execute();
        Assert.assertSame((Object)startedTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void testRunWasSuccess() {
        final TransactionalInteger v = new TransactionalInteger(0);
        Transaction t = this.startUpdateTransaction();
        new OrElseTemplate(){

            public Object run(Transaction t) {
                v.set(10);
                return null;
            }

            public Object orelserun(Transaction t) {
                Assert.fail();
                return null;
            }
        }.execute();
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)10L, (long)v.get());
    }

    @Test
    public void testRunWasFailureTryOrElseRun() {
        final TransactionalInteger v = new TransactionalInteger(0);
        Transaction t = this.startUpdateTransaction();
        new OrElseTemplate(){

            public Object run(Transaction t) {
                v.set(10);
                StmUtils.retry();
                return null;
            }

            public Object orelserun(Transaction t) {
                v.set(20);
                return null;
            }
        }.execute();
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)20L, (long)v.get());
    }

    @Test
    public void testRunWasFailureTryOrElseRunWasAlsoFailure() {
        final TransactionalInteger v = new TransactionalInteger(0);
        Transaction t = this.startUpdateTransaction();
        try {
            new OrElseTemplate(){

                public Object run(Transaction t) {
                    v.set(10);
                    StmUtils.retry();
                    return null;
                }

                public Object orelserun(Transaction t) {
                    v.set(20);
                    StmUtils.retry();
                    return null;
                }
            }.execute();
            Assert.fail();
        }
        catch (Retry retry) {
            // empty catch block
        }
        t.abort();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{t});
        Assert.assertEquals((long)0L, (long)v.get());
    }

    class WThread
    extends TestThread {
        private final TransactionalInteger orRef;
        private final TransactionalInteger elseRef;
        private String result;

        WThread(TransactionalInteger orRef, TransactionalInteger elseRef) {
            super("WaitThread");
            this.orRef = orRef;
            this.elseRef = elseRef;
        }

        public void doRun() throws Exception {
            TransactionFactory txFactory = OrElseTemplateTest.this.stm.getTransactionFactoryBuilder().setReadonly(false).setReadTrackingEnabled(true).build();
            this.result = (String)new TransactionTemplate<String>(txFactory){

                public String execute(Transaction t) throws Exception {
                    return (String)new OrElseTemplate<String>(){

                        public String run(Transaction tx) {
                            if (WThread.this.orRef.get() == 0) {
                                StmUtils.retry();
                            }
                            return "run";
                        }

                        public String orelserun(Transaction tx) {
                            if (WThread.this.elseRef.get() == 0) {
                                StmUtils.retry();
                            }
                            return "orelserun";
                        }
                    }.execute();
                }
            }.execute();
        }
    }
}

