/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class TransactionTemplate_conflictStressTest {
    private int threadCount = 4;
    private int transactionsPerThread = 500000;
    private int refCount = 40;
    private TransactionalInteger[] refs;
    private Stm stm;
    private IncThread[] threads;

    @Before
    public void setUp() {
        int k;
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.refs = new TransactionalInteger[this.refCount];
        for (k = 0; k < this.refCount; ++k) {
            this.refs[k] = new TransactionalInteger();
        }
        this.threads = new IncThread[this.threadCount];
        for (k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new IncThread(k);
        }
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    private int sum() {
        int sum = 0;
        for (TransactionalInteger ref : this.refs) {
            sum += ref.get();
        }
        return sum;
    }

    @Test
    public void test() {
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        Assert.assertEquals((long)(this.refs.length * this.threadCount * this.transactionsPerThread), (long)this.sum());
    }

    public class IncThread
    extends TestThread {
        public IncThread(int id) {
            super("IncThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < TransactionTemplate_conflictStressTest.this.transactionsPerThread; ++k) {
                if (k % 10000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                this.action();
            }
        }

        public void action() {
            TransactionFactory txFactory = TransactionTemplate_conflictStressTest.this.stm.getTransactionFactoryBuilder().setReadonly(false).setFamilyName(((Object)((Object)this)).getClass() + "action()").setReadTrackingEnabled(false).build();
            new TransactionTemplate(txFactory){

                public Object execute(Transaction tx) throws Exception {
                    for (int k = 0; k < TransactionTemplate_conflictStressTest.this.refCount; ++k) {
                        TransactionTemplate_conflictStressTest.this.refs[k].inc();
                    }
                    return null;
                }
            }.execute();
        }
    }
}

