/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.templates.TransactionTemplate;

public class TransactionTemplate_threadLocalTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TransactionTemplate t = new TransactionTemplate(this.stm){

            public Object execute(Transaction tx) throws Exception {
                return null;
            }
        };
        Assert.assertTrue((boolean)t.isThreadLocalAware());
    }

    @Test
    public void whenThreadLocalIgnoredAndTransactionActive_thenNewTransactionCreated() {
        Transaction active = this.stm.getTransactionFactoryBuilder().build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)active);
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().build();
        Transaction found = (Transaction)new TransactionTemplate<Transaction>(txFactory, false, false, true){

            public Transaction execute(Transaction tx) throws Exception {
                return tx;
            }
        }.execute();
        Assert.assertNotNull((Object)found);
        Assert.assertNotSame((Object)active, (Object)found);
        Assert.assertSame((Object)active, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }
}

