/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_atomicCompareAndSetStressTest {
    private int refCount = 1000;
    private int threadCount = 10;
    private TransactionalReferenceArray<Integer> array;
    private int iterationCount = 1000000;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.array = new TransactionalReferenceArray(this.refCount);
        for (int k = 0; k < this.array.length(); ++k) {
            this.array.set(k, (Object)0);
        }
        TestThread[] threads = new WorkerThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new WorkerThread(k);
        }
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        Assert.assertEquals((long)this.sum((WorkerThread[])threads), (long)this.sum());
    }

    public int sum(WorkerThread[] threads) {
        int result = 0;
        for (WorkerThread thread : threads) {
            result += thread.incCount;
        }
        return result;
    }

    public int sum() {
        int result = 0;
        for (int k = 0; k < this.array.length(); ++k) {
            result += ((Integer)this.array.get(k)).intValue();
        }
        return result;
    }

    class WorkerThread
    extends TestThread {
        private int incCount;

        public WorkerThread(int id) {
            super("WorkerThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < TransactionalReferenceArray_atomicCompareAndSetStressTest.this.iterationCount; ++k) {
                this.incCount += this.doit();
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        private int doit() {
            int inc = 0;
            for (int k = 0; k < TransactionalReferenceArray_atomicCompareAndSetStressTest.this.array.length(); ++k) {
                if (!TestUtils.randomOneOf((int)(TransactionalReferenceArray_atomicCompareAndSetStressTest.this.refCount / 10))) continue;
                int x = (Integer)TransactionalReferenceArray_atomicCompareAndSetStressTest.this.array.atomicGet(k);
                if (!TransactionalReferenceArray_atomicCompareAndSetStressTest.this.array.atomicCompareAndSet(k, (Object)x, (Object)(x + 1))) continue;
                ++inc;
            }
            return inc;
        }
    }
}

